/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

@ClassCategory(value={EClassCategory.JAVAFX})
public class MainGameSceneBackground
extends Group {
    private static final int MORTAR_SQUARE_DIM = 12;
    private static final int MORTAR_CORNER_DIM = 10;
    private IImageLoader loader;
    private double sceneWidth;
    private double sceneHeight;
    private double topLeftWidth;
    private HBox topFringRepeated;
    private VBox rightBorder;
    private HBox bottomBorder;
    private ImageView ornamentView;

    public MainGameSceneBackground(double width, double height, IImageLoader loader) {
        this.setManaged(false);
        this.loader = loader;
        this.sceneWidth = width;
        this.sceneHeight = height;
        Image topLeftImage = loader.getImage("images/FrameLayout");
        ImageView topLeft = new ImageView(topLeftImage);
        this.topFringRepeated = new HBox();
        this.setupTopFringe(width);
        this.rightBorder = new VBox();
        this.setupRightBorder(width, height);
        this.bottomBorder = new HBox();
        this.setupBottomBorder(width, height);
        this.ornamentView = new ImageView();
        this.setupOrnament(height);
        this.getChildren().addAll((Object[])new Node[]{topLeft, this.topFringRepeated, this.rightBorder, this.bottomBorder, this.ornamentView});
    }

    private void setupOrnament(double height) {
        this.ornamentView.setLayoutY(666.0);
        int decoHeight = (int)Math.floor(height - 666.0);
        String ornamentName = decoHeight < 125 ? "images/Ornament310x94" : (decoHeight < 158 ? "images/Ornament310x155" : (decoHeight < 173 ? "images/Ornament310x162" : (decoHeight < 248 ? "images/Ornament310x185" : (decoHeight < 387 ? "images/Ornament310x310" : (decoHeight < 492 ? "images/Ornament310x464" : (decoHeight < 569 ? "images/Ornament310x519" : (decoHeight < 633 ? "images/Ornament310x619" : (decoHeight < 839 ? "images/Ornament310x646" : "images/Ornament310x1032"))))))));
        Image ornament = this.loader.getImage(ornamentName, 310.0, (double)decoHeight);
        this.ornamentView.setImage(ornament);
    }

    private void setupBottomBorder(double width, double height) {
        this.bottomBorder.getChildren().clear();
        this.bottomBorder.setLayoutX(310.0);
        this.bottomBorder.setLayoutY(height - 10.0);
        int defaultPlateding = 200;
        double horizontalSpaceToFill = width - 310.0 - 15.0;
        int onePlateHeigth = 212;
        int countComplete = (int)Math.round(horizontalSpaceToFill / (double)onePlateHeigth);
        int bottomBorderMiddleOrigWidth = 374;
        int unscaledWidth = (countComplete + 1) * bottomBorderMiddleOrigWidth;
        double horizontalFillSpaceWithPlating = horizontalSpaceToFill - (double)(countComplete * 12);
        double scale = horizontalFillSpaceWithPlating / (double)unscaledWidth;
        double bottomBorderMiddleDestWidth = (double)bottomBorderMiddleOrigWidth * scale;
        Image bottomBoderMiddle = this.loader.getImage("images/bottomBorderMiddle", bottomBorderMiddleDestWidth, 10.0);
        Image leftbottomCornerMortar = this.loader.getImage("images/leftBottomBorderCorner");
        ImageView bottomRightMortarCornerView = new ImageView(leftbottomCornerMortar);
        Rectangle2D leftBottomMortarCornerViewport = new Rectangle2D(5.0, 0.0, 5.0, 10.0);
        bottomRightMortarCornerView.setViewport(leftBottomMortarCornerViewport);
        this.bottomBorder.getChildren().add((Object)bottomRightMortarCornerView);
        Image bottomMortar = this.loader.getImage("images/bottomBorderMortar");
        int coveredWidth = (int)Math.floor(325.0 + (double)(countComplete + 1) * bottomBoderMiddle.getWidth() + (double)countComplete * bottomMortar.getWidth());
        int diff = (int)Math.ceil(width - (double)coveredWidth);
        for (int w = 0; w <= countComplete; ++w) {
            if (w < countComplete) {
                ImageView imgView = new ImageView(bottomBoderMiddle);
                this.bottomBorder.getChildren().add((Object)imgView);
                ImageView bottomMortarImgView = new ImageView(bottomMortar);
                this.bottomBorder.getChildren().add((Object)bottomMortarImgView);
                continue;
            }
            Image bottomBoderMiddleWider = this.loader.getImage("images/bottomBorderMiddle", bottomBorderMiddleDestWidth + (double)diff, 10.0);
            ImageView imgView = new ImageView(bottomBoderMiddleWider);
            this.bottomBorder.getChildren().add((Object)imgView);
        }
    }

    private void setupRightBorder(double width, double height) {
        this.rightBorder.getChildren().clear();
        int defaultPlateding = 200;
        double verticalSpaceToFill = height - 70.0 - 15.0;
        int onePlateHeigth = 212;
        int countComplete = (int)Math.round(verticalSpaceToFill / (double)onePlateHeigth);
        int reightBorderMiddleOrigHeight = 374;
        int unscaledHeigth = (countComplete + 1) * reightBorderMiddleOrigHeight;
        double horizontalFillSpaceWithPlaging = verticalSpaceToFill - (double)(countComplete * 12);
        double scale = horizontalFillSpaceWithPlaging / (double)unscaledHeigth;
        double reightBorderMiddleDestHeight = (double)reightBorderMiddleOrigHeight * scale;
        Image reightBoderMiddle = this.loader.getImage("images/reightBorderMiddle", 10.0, reightBorderMiddleDestHeight);
        Image topRightMortar = this.loader.getImage("images/rightTopBorderCorner");
        Rectangle2D topRightMortarViewport = new Rectangle2D(0.0, 5.0, 10.0, 5.0);
        ImageView topRightMortartImgView = new ImageView(topRightMortar);
        topRightMortartImgView.setViewport(topRightMortarViewport);
        this.rightBorder.getChildren().add((Object)topRightMortartImgView);
        Image rightMortar = this.loader.getImage("images/reightBorderMortar");
        int coveredHeigth = (int)Math.floor(85.0 + (double)(countComplete + 1) * reightBoderMiddle.getHeight() + (double)countComplete * rightMortar.getHeight());
        int diff = (int)Math.ceil(height - (double)coveredHeigth);
        for (int h = 0; h <= countComplete; ++h) {
            if (h < countComplete) {
                ImageView imgView = new ImageView(reightBoderMiddle);
                this.rightBorder.getChildren().add((Object)imgView);
                ImageView rightMortartImgView = new ImageView(rightMortar);
                this.rightBorder.getChildren().add((Object)rightMortartImgView);
                continue;
            }
            Image reightBoderMiddleHeiger = this.loader.getImage("images/reightBorderMiddle", 10.0, reightBorderMiddleDestHeight + (double)diff);
            ImageView imgView = new ImageView(reightBoderMiddleHeiger);
            this.rightBorder.getChildren().add((Object)imgView);
        }
        Image bottomRightMortar = this.loader.getImage("images/rightBottomBorderCorner");
        ImageView bottomRightMortartImgView = new ImageView(bottomRightMortar);
        this.rightBorder.getChildren().add((Object)bottomRightMortartImgView);
        this.rightBorder.setLayoutY(70.0);
        this.rightBorder.setLayoutX(width - 10.0);
    }

    private void setupTopFringe(double width) {
        double remWidth = width - this.topLeftWidth;
        this.topFringRepeated.getChildren().clear();
        Image topFringe = this.loader.getImage("images/topDeco");
        this.topLeftWidth = topFringe.getWidth();
        double decoWidth = topFringe.getWidth();
        int countComplete = (int)Math.floor(remWidth / decoWidth);
        double partialWidth = remWidth - (double)countComplete * decoWidth;
        for (int i = 0; i < countComplete; ++i) {
            ImageView imgView = new ImageView(topFringe);
            this.topFringRepeated.getChildren().add((Object)imgView);
        }
        Rectangle2D viewportTopRight = new Rectangle2D(0.0, 0.0, partialWidth, topFringe.getHeight());
        ImageView topRight = new ImageView(topFringe);
        topRight.setViewport(viewportTopRight);
        this.topFringRepeated.getChildren().add((Object)topRight);
        this.topFringRepeated.layoutXProperty().set(this.topLeftWidth);
    }

    public void widthChange(double oldWidth, double newWidth) {
        this.setupTopFringe(newWidth);
        this.setupRightBorder(newWidth, this.sceneHeight);
        this.setupBottomBorder(newWidth, this.sceneHeight);
        this.sceneWidth = newWidth;
    }

    public void heightChange(double oldHeight, double newHeigth) {
        if (newHeigth > 600.0) {
            this.setupRightBorder(this.sceneWidth, newHeigth);
            this.setupBottomBorder(this.sceneWidth, newHeigth);
            this.setupOrnament(newHeigth);
        }
        this.sceneHeight = newHeigth;
    }

    double getSceneWidth() {
        return this.sceneWidth;
    }

    double getSceneHeight() {
        return this.sceneHeight;
    }
}

