/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class LinePathConverter
implements IPathConverter {
    @Autowired
    private TravellingVessels vessels;

    public Optional<Path> createPath(INavigableVessel vessel, List<Point2D> pointedPath, double scale) {
        Path path = new Path();
        path.setStroke((Paint)Color.RED);
        path.setStrokeWidth(2.0);
        if (!pointedPath.isEmpty()) {
            Point2D p = pointedPath.get(0);
            MoveTo moveTo = new MoveTo();
            moveTo.setX(p.getX() * scale);
            moveTo.setY(p.getY() * scale);
            path.getElements().add((Object)moveTo);
            for (int i = 1; i < pointedPath.size(); ++i) {
                p = pointedPath.get(i);
                LineTo lineTo = new LineTo();
                lineTo.setX(p.getX() * scale);
                lineTo.setY(p.getY() * scale);
                path.getElements().add((Object)lineTo);
            }
        }
        this.vessels.addVessel(vessel, Optional.ofNullable(path), pointedPath);
        return Optional.ofNullable(path);
    }

    public List<Point2D> reduceLinePoints(List<Point2D> initialPoints) {
        return initialPoints;
    }

    public long calculateDuration(INavigableVessel vessel, PathInterpolator interpolator, double fraction) {
        return 0L;
    }
}

