package ch.sahits.game.openpatrician.display;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.eventbus.EventBus;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 02, 2016
 */
@Slf4j
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CheatKeyEventListener implements EventHandler<KeyEvent> {
    @Autowired
    @ListType(ICheatCommand.class)
    private List<ICheatCommand> cheatCommands;
    @Autowired
    @Qualifier("clientEventBus")
    private EventBus clientEventBus;

    private boolean cheatModeActive = false;
    @Override
    public void handle(KeyEvent event) {
        try {
            if (event.getCode().equals(KeyCode.F10)) {
                cheatModeActive = !cheatModeActive;
                log.debug("Toggle cheatmode. Cheat active: {}", cheatModeActive);
            } else {
                if (cheatModeActive && event.isControlDown()) {
                    Optional<ICheatCommand> commandOpt = getCheatCommandsActivatedByControl().stream()
                            .filter(cheat -> cheat.getKey().equals(event.getCode()))
                            .findFirst();
                    if (commandOpt.isPresent()) {
                       ICheatCommand cheatCommand = commandOpt.get();
                       clientEventBus.post(new ViewChangeEvent(MainGameView.class, cheatCommand));
                    }
                }
            }
        } catch (RuntimeException e) {
            log.error("Failed to toggle cheat command: "+event.getCode(), e);
        }
    }

    private List<ICheatCommand> getCheatCommandsActivatedByControl() {
        return cheatCommands.stream()
                .filter(command -> command.getControlKey().equals(KeyCode.CONTROL))
                .collect(Collectors.toList());
    }

}
