package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.ChildBirthState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 11, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class ChildBirthDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private ChildBirthState state;

    public ChildBirthDialog(ChildBirthState state) {
        super(true);
        this.state = state;
    }
    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        addDecoratedText("letter.dairy.entry", "diryEntry");
        addVerticalSpacer(20);
        if (state.isMale()) {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.maleChild", "maleChild", state.getName());
        } else {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.femaleChild", "femaleChild", state.getName());
        }
        if (state.isWifeDeath()) {
            addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.ChildBirthDialog.wifeDeath", "wifeDeath");
        }
    }
}
