package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.DonationRequestState;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;

/**
 * Dialog for a donation request
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Nov 02, 2018
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class DonationRequestDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private ClientViewState clientViewState;

    private final DonationRequestState state;

    public DonationRequestDialog(DonationRequestState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String date = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), date);
        addVerticalSpacer(20);
        if (state.isGenderMale()) {
            addDecoratedText("letter.salutation.male", "salutationMale", state.getToLastName());
        } else {
            addDecoratedText("letter.salutation.female", "salutationFemale", state.getToLastName());
        }
        addVerticalSpacer(20);
        addDecoratedText(state.getMessageKey(), "content", state.getAmount());

        OpenPatricianLargeWaxButton button = addActionButton("ch.sahits.game.openpatrician.display.dialog.events.DonationRequestDialog.donate", "acceptBtn");
        button.setId("acceptBtn");
        if (state.isAccepted()) {
            button.setDisable(true);
        } else {
            button.setOnAction(event -> {
                clientViewState.getPlayer().getCompany().updateCash(-state.getAmount());
                state.setAccepted(true);
                executeOnCloseButtonClicked();
            });
        }
    }
}