package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageAnnouncementState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Dialog to display the marriage anouncement.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 08, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageAnnouncementDialog extends DefaultSimpleDialog {
    private final MarriageAnnouncementState state;
    @Autowired
    private ModelTranslations modelTranslations;

    public MarriageAnnouncementDialog(MarriageAnnouncementState state) {
        super(true);
        this.state = state;
    }
    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        String tillDate = modelTranslations.toDisplayStringLongFormat(state.getWeddingDate());

        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getSpouse().getBirthPlace().getName(), letterDate);
        addVerticalSpacer(20);
        addDecoratedText("letter.congratulations", "salutation", Pos.CENTER);
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.MarriageAnnouncementDialog.paragraph1", "marriage", state.getSpouse().getName(), state.getSpouse().getLastName(), tillDate);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.MarriageAnnouncementDialog.paragraph2", "supplies", state.getPlayer().getHometown().getName());
    }
}
