package ch.sahits.game.openpatrician.display.dialog.guild;

import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.model.city.guild.GuildSettings;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Dialog to display the Mediterranean map with the explored and discovered locations.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 04, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class GuildMediterraneanMapDialog extends CloseButtonDialog {
    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private GuildSettings guildSettings;
    @Autowired
    private IImageUtilities imageUtilities;

    public GuildMediterraneanMapDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.GuildMediterraneanMapDialog.title",
                new Object[]{}, locale.getCurrentLocal()));
        IMediterreanMap map = guildSettings.getMediterreanMap();
        Image image = imageUtilities.createMediterraneanMap(city.getPlayer(), map);
        ImageView imgView = new ImageView(image);
        imgView.setId("mediterraneanMap");
        imgView.setFitWidth(WRAPPING_WIDTH);
        imgView.setPreserveRatio(true);
        VBox box = new VBox(imgView);
        box.setLayoutX(2 * FRAME_BORDER);
        box.setLayoutY(CLOSE_BTN_Y_POS - 500);
        getContent().add(box);
    }
}
