package ch.sahits.game.openpatrician.display.dialog.sea;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ConvoyService;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.IDialogCentralButton;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * Dialog handling the leaving of a ship from a convoy.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 08, 2016
 */
@Slf4j
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LeaveConvoyDialog extends CloseButtonDialog implements IDialogCentralButton{
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @Autowired
    private ConvoyService convoyService;

    private final IConvoy convoy;
    private final IShip ship;

    public LeaveConvoyDialog(ICityPlayerProxyJFX city, IConvoy convoy, IShip ship) {
        this.convoy = convoy;
        this.ship = ship;
    }

    @PostConstruct
    private void initializeDialog() {

        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.title", new Object[]{}, locale.getCurrentLocal()));
        String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.text", new Object[]{ship.getName(), convoy.getName()}, locale.getCurrentLocal());
        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
        VBox box = new VBox(text);
        box.setLayoutX(50);
        box.setLayoutY(CLOSE_BTN_Y_POS - 500);


        OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.leave", new Object[]{}, locale.getCurrentLocal()));
        acceptBtn.getStyleClass().add("actionButton");
        acceptBtn.setId("actionButton");
        acceptBtn.setLayoutX(BUTTON_X);
        acceptBtn.setOnAction(createAcceptHandler(ship));
        acceptBtn.setLayoutY(UPPER_BUTTON_Y);

        getContent().addAll(box, acceptBtn);

    }

    private EventHandler<MouseEvent> createAcceptHandler(IShip ship) {
        return event -> {
            try {
                convoyService.leave(convoy, ship);
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                log.error("Failed to leave convoy", e);
            }
        };
    }
}
