package ch.sahits.game.openpatrician.display.event.data;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import javafx.geometry.Point2D;
import lombok.Value;

import java.util.Optional;

/**
 * Created by andi on 26.03.17.
 */
@Value
@ClassCategory(EClassCategory.EVENT_OBJECT)
public class DelayedTravelToEvent implements IEventMetaDataProvider {
    private Point2D destination;
    private INavigableVessel vessel;
    @OptionalType(ICity.class)
    private Optional<ICity> city;
    private String className;
    private String methodName;

    public DelayedTravelToEvent(Point2D destination, INavigableVessel vessel, Optional<ICity> city) {
        this.destination = destination;
        this.vessel = vessel;
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
