package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISailors;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * Event handler runnable for changing the tavern dialog.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 17, 2014
 */
@Prototype
@ClassCategory({EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
class TavernDialogChangeAction implements Runnable {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private final IPerson showingPerson;
    private final TavernState tavernState;
    private final IPlayer player;
    private final EDialogType dialogType;

    public TavernDialogChangeAction(IPerson showingPerson,
                                    TavernState tavernState,
                                    IPlayer currentPlayer, EDialogType dialogType) {
        this.showingPerson = showingPerson;
        this.tavernState = tavernState;
        this.player = currentPlayer;
        this.dialogType = dialogType;
    }

    @Override
    public void run() {
        boolean doUpdate= (dialogType != null);
        boolean canTalkToOnlyOnePerson = true;
        if (showingPerson instanceof ISailors) {
            canTalkToOnlyOnePerson = false;
        }
        if (showingPerson instanceof IWeaponsDealer) {
            canTalkToOnlyOnePerson = false;
        }

        if (doUpdate) {
            if (canTalkToOnlyOnePerson) {
                tavernState.talkingToProperty().get().put(showingPerson, player);
            }
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, dialogType));
        }
    }}
