package ch.sahits.game.openpatrician.display.gameplay.impl;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 19, 2016
 */
@Slf4j
public abstract class AbstractMarketPlaceBuildingPolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public AbstractMarketPlaceBuildingPolygonInitializer(String sceneName) {
        super(sceneName);
    }

    /**
     * Event to return to the marcet place scene.
     * @return mouse evennt handler for the back action
     */
    protected EventHandler<MouseEvent> createBackToMarketPlaceEvent() {
        return event -> {
            try {
                ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_MARKET);
                clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                clientEventBus.post(new NoticeBoardUpdate(proxy));
            } catch (RuntimeException e) {
                log.error("Failed to switch back to market place", e);
            }
        };
    }
}
