package ch.sahits.game.openpatrician.display.javafx;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.shape.Polygon;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 26, 2015
 */
public abstract class BaseMainGameImageView extends Group {
    protected boolean withPolygonShading = false;
    private Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK};

    public BaseMainGameImageView() {
        if (System.getProperty("javafx.polygon.shading") != null) {
            withPolygonShading = true;
        }
        setManaged(false);
    }

    /**
     * Initialize the polygons
     * @param polygons List of polygons that are to be reset.
     */
    public void resetPolygons(List<Polygon> polygons) {
        ImageView imageView = getImageView();
        for (int i = 0; i < polygons.size(); i++) {
            Polygon polygon = polygons.get(i);
            if (imageView != null) {
                polygon.setLayoutX(imageView.getLayoutX());
                polygon.setLayoutY(imageView.getLayoutY());
            }
            if (withPolygonShading) {
                polygon.setFill(colors[i%colors.length]);
                polygon.setOpacity(0.5);
            } else {
                polygon.setFill(Color.TRANSPARENT);
            }

            getChildren().add(polygon);
        }
    }

    private ImageView getImageView() {
        for (Node node : getChildren()) {
            if (node instanceof ImageView) {
                return (ImageView) node;
            }
        }
        return null;
    }
}
