package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import javafx.beans.property.ObjectProperty;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 12, 2013
 */
public interface ISceneEventHandler {
    /**
     * Representing the current scene.
     * @return property holding the current scene value.
     */
    ObjectProperty<EScene> currentSceneProperty();

    /**
     * Set up the dialog controller, which defines the callback methods
     * @param dialogContoller inject the dialog controller
     */
    void setDialogContoller(IDialogContoller dialogContoller);

    /**
     * Handle the event
     * @param eventNotice handle an event
     */
    void handleEvent(Object eventNotice);
}
