package ch.sahits.game.openpatrician.display.javafx;

import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.gameplay.impl.EScene;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.javafx.event.WrappedDialogType;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 12, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.HANDLER)
public class PortSceneEventHandler implements ISceneEventHandler {
    @ObjectPropertyType(EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty<>(this, "currentScene", EScene.PORT);
    @Autowired
    private ClientViewState viewState;

    private IDialogContoller dialogContoller; // this instance exists not at startup
    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull(dialogContoller, "Dialog controller must be initialized first");
                   if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
                       ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX) eventNotice;
                       // trade city ship
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_TRADE) {
                           // Dialog City ship
                           dialogContoller.setNewDialog(EDialogType.PORT_CITY_TO_SHIP);
                       }
                       // trading office
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_TRADING_OFFICE) {
                           // Dialog City ship
                           dialogContoller.setNewDialog(EDialogType.TO_BALANCE);
                       }
                       // Scene change market place
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_MARKET) {
                           currentScene.set(EScene.MARKET);
                           dialogContoller.changeScene();
                       }
                       // Scene change shipyard
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_SHIPYARD) {
                           currentScene.set(EScene.SHIPYARD);
                           dialogContoller.changeScene();
                       }
                       // Scene change tavern
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_TAVERN) {
                           currentScene.set(EScene.TAVERN);
                           dialogContoller.changeScene();
                       }
                       // Scene change loaner office
                       if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_LOANER) {
                           currentScene.set(EScene.LOANER);
                           dialogContoller.changeScene();
                       }

                   }
                   if (eventNotice instanceof EDialogType) {
                       dialogContoller.replaceDialog((EDialogType) eventNotice);
                   }
        if (eventNotice instanceof WrappedDialogType) {
            final WrappedDialogType notice = (WrappedDialogType) eventNotice;
            dialogContoller.replaceDialog(notice.getDialogType(), notice.getParams());
        }
    }
}
