package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

/**
 * Factory for User actions.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 01, 2017
 */
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class UserActions {
    @Autowired
    private ApplicationContext context;

    public Ship2StorageJFXAction ship2StorageAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(Ship2StorageJFXAction.class, ware, transfer);
    }

    public City2StorageJFXAction city2StorageAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(City2StorageJFXAction.class, ware, transfer);
    }

    public City2ShipJFXAction city2ShipAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(City2ShipJFXAction.class, ware, transfer);
    }

    public Ship2CityJFXAction ship2CityAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(Ship2CityJFXAction.class, ware, transfer);
    }

    public Storage2CityJFXAction storage2CityAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(Storage2CityJFXAction.class, ware, transfer);
    }

    public Storage2ShipJFXAction storage2ShipAction(IWare ware, ITransferableJFX transfer) {
        return context.getBean(Storage2ShipJFXAction.class, ware, transfer);
    }
}
