package ch.sahits.game.openpatrician.display.javafx.control;

import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.SceneChangeable;
import ch.sahits.game.openpatrician.display.scene.InGameOptionsScene;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.event.NavigationStateChange;
import ch.sahits.game.openpatrician.javafx.control.TogglebleImageButton;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.scene.Group;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Control representing the main menu.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 1, 2013
 *
 */
@Slf4j
@ClassCategory({EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MainMenu extends Group implements IMainMenuControl {
	private static final double IMAGE_SCALE = 1;
	@Autowired
	@Qualifier("xmlImageLoader")
	private IDataImageLoader imageLoader;
	@Autowired
	private UIFactory uiFactory;
	@Autowired
	private ClientViewState viewState;
	@Autowired
	@Qualifier("clientEventBus")
	private AsyncEventBus clientEventBus;
	@Autowired
	private ITrackPlayer soundPlayer;
	@Autowired
	@Qualifier("timerEventBus")
	private AsyncEventBus timerEventBus;
	private boolean navigationDisabled = false;

	private SceneChangeable sceneChangeable;
	private ISubMenuControl subMenuControl;
	private TogglebleImageButton messagesGraphic;

	public MainMenu() {
		setManaged(false);
	}
	@PreDestroy
	private void unregister() {
		clientEventBus.unregister(this);
	}
	@PostConstruct
	private void initializeControls() {
		clientEventBus.register(this);
		sceneChangeable = uiFactory.getApplicationWindow();
		HBox iconBar = new HBox(2);

		final Image shipSelectionImg = imageLoader.getImage("icons/32/icon_ship_selection");
		final Image inactiveMessagesIcon = imageLoader.getImage("icons/32/paperscrolls-icon");
		final Image activeMessagesIcon = imageLoader.getImage("icons/32/paperscrolls-unfurled-icon");
		final ImageView shipSelectionGraphic = new ImageView(shipSelectionImg);
		Label shipSelection = new Label();
		shipSelection.setGraphic(shipSelectionGraphic);
		shipSelection.setScaleX(IMAGE_SCALE);
		shipSelection.setScaleY(IMAGE_SCALE);
		shipSelection.setOnMouseReleased(mouseEvent -> {
			if (!navigationDisabled) {
				subMenuControl.displayShipSubNavigation();
				if (messagesGraphic.getActive()) {
					messagesGraphic.toggle();
				}
			}
		});
		messagesGraphic = new TogglebleImageButton(inactiveMessagesIcon, activeMessagesIcon);
		Label messages = new Label();
		messages.setGraphic(messagesGraphic);
		messages.setScaleX(IMAGE_SCALE);
		messages.setScaleY(IMAGE_SCALE);
        messages.setOnMouseReleased(mouseEvent -> {
            if (!navigationDisabled) {
                if (messagesGraphic.getActive()) {
					subMenuControl.closeSubMenuNavigation();
				} else {
					subMenuControl.displayMessageSubNavigation();
                }
                messagesGraphic.toggle();
            }
        });

		final ImageView optionsGraphic = new ImageView(imageLoader.getImage("icons/32/anchor"));
		Label options = new Label();
		options.setGraphic(optionsGraphic);
		options.setScaleX(IMAGE_SCALE);
		options.setScaleY(IMAGE_SCALE);
		options.setOnMouseReleased(mouseEvent -> {
            if (!navigationDisabled) {
                soundPlayer.stop();
                timerEventBus.post(new PauseGame());
                InGameOptionsScene options1 = uiFactory.getInGameOptionsScene();
                options1.initializeState();
                options1.setSceneChangeable(sceneChangeable);
                sceneChangeable.changeScene(options1);
            }

        });

		iconBar.getChildren().addAll(shipSelection, messages, options);
		// Layout values are dependent on the label scale
		iconBar.setLayoutX(2);
		iconBar.setLayoutY(6);
		getChildren().addAll(iconBar);

	}

	@Subscribe
	public void handleNavigationChange(NavigationStateChange event) {
		switch (event.getChange()) {
			case DISABLE_NAVIGATION:
				navigationDisabled = true;
				break;
			case ENABLE_NAVIGATION:
				navigationDisabled = false;
				break;
			default:
				log.info("Not interested in navigation change event: "+event.getChange());
		}
	}

	@Override
	public void registerSubNavigationCallback(ISubMenuControl subMenuControl) {
		this.subMenuControl =subMenuControl;
	}

	@Override
	public void closeMessageSubMenu() {
		messagesGraphic.toggle();
	}
}
