package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.GenericTriple;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ISingleSelectableCheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.scene.input.KeyCode;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * Cheat to add a ship of a selected type in the current city by CTRL+S.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on May 04, 2018
 */
@Getter
@Slf4j
@Component
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CreateShipCheat implements ISingleSelectableCheatCommand {
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.S;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.CreateShipCheat.desc";
    @ListType(GenericTriple.class)
    private final List<GenericTriple<String>> options = new ArrayList<>();
    @Setter
    private GenericTriple<String> selectedOption;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @PostConstruct
    private void init() {
        for (EShipType shipType : EShipType.values()) {
            String display = messageSource.getMessage(shipType.name(), new Object[0], locale.getCurrentLocal());
            options.add(new GenericTriple<>(String.valueOf(shipType.ordinal()), shipType.name(), display));
        }
        selectedOption = options.get(0);
    }
    @Override
    public void execute() {
        ClientViewState viewState = context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        ICity city = viewState.getCurrentCityProxy().get().getCity();
        ShipFactory shipFactory = context.getBean(ShipFactory.class);
        IShip ship;
        EShipType shipType = EShipType.valueOf(selectedOption.getSecond());
        switch (shipType) {
            case SNAIKKA:
                ship = shipFactory.createSnaikka("Cheat ship name", EShipUpgrade.LEVEL1, 250);
                break;
            case CRAYER:
                ship = shipFactory.createCrayer("Cheat ship name", EShipUpgrade.LEVEL1, 350);
                break;
            case COG:
                ship = shipFactory.createCog("Cheat ship name", EShipUpgrade.LEVEL1, 550);
                break;
            case HOLK:
                ship = shipFactory.createHolk("Cheat ship name", EShipUpgrade.LEVEL1, 700);
                break;
            default:
                ship = null;
        }
        ship.setOwner(player);
        player.addShip(ship);
        player.addSelectableVessel(ship);
        ship.setLocation(city.getCoordinates());
        viewState.getCurrentCityProxy().get().arrive(ship);
        log.debug("Cheat created a new ship in " + city.getName());
    }

}
