/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display;

import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.graphic.image.ImageConfiguration;
import ch.sahits.game.graphic.loaders.IImageLoaderComponents;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.event.SubscriptionLoggingExceptionHandler;
import ch.sahits.game.openpatrician.display.event.handler.impl.IOpenPatricianDisplayEventHandlerComponents;
import ch.sahits.game.openpatrician.display.event.task.IOpenPatricianDisplayTaskComponents;
import ch.sahits.game.openpatrician.display.model.CityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.javafx.control.BaleAmount;
import ch.sahits.game.openpatrician.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.BaleIconView;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.BarrelIconView;
import ch.sahits.game.openpatrician.javafx.control.CheatMenu;
import ch.sahits.game.openpatrician.javafx.control.CoinIconView;
import ch.sahits.game.openpatrician.javafx.control.CoinPrice;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.FightingSkillAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.NavigationSkillAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.javafx.control.TradingSkillAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.model.IOpenPatricianJAvaFXModelComponents;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.IOpenPatricianJavaFXServiceComponents;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.sound.SoundConfiguration;
import ch.sahits.game.openpatrician.utilities.PausableAsyncEventBus;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.plugin.PluginConfiguration;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javafx.beans.property.ReadOnlyDoubleProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

@Configuration
@Import(value={ImageConfiguration.class, SoundConfiguration.class, PluginConfiguration.class})
@ComponentScan(basePackageClasses={UICommonConfiguration.class, IImageLoaderComponents.class, IOpenPatricianJAvaFXModelComponents.class, IOpenPatricianJavaFXServiceComponents.class, IOpenPatricianDisplayEventHandlerComponents.class, IOpenPatricianDisplayTaskComponents.class, IOpenPatricianJavaFXServiceComponents.class})
@ClassCategory(value={EClassCategory.STARTUP})
public class UICommonConfiguration {
    @Bean
    public DecoratedTextFactory decoratedDialogTextFactory() {
        return new DecoratedTextFactory(30, 100, 458);
    }

    @Bean
    public Jaxb2Marshaller jaxb2MarshallerImage() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data.image");
        return bean;
    }

    @Bean
    public Jaxb2Marshaller jaxb2MarshallerPolygon() {
        Jaxb2Marshaller bean = new Jaxb2Marshaller();
        bean.setContextPath("ch.sahits.game.graphic.data.polygon");
        return bean;
    }

    @Bean
    public ExecutorService clientThreadPool() {
        return Executors.newSingleThreadExecutor();
    }

    @Bean
    public SubscriptionLoggingExceptionHandler subscriptionExceptionClientHandler() {
        return new SubscriptionLoggingExceptionHandler();
    }

    @Bean
    public PausableAsyncEventBus clientEventBus() {
        return new PausableAsyncEventBus((Executor)this.clientThreadPool(), (SubscriberExceptionHandler)this.subscriptionExceptionClientHandler());
    }

    @Bean
    public ReloadableResourceBundleMessageSource resourceReference() {
        ReloadableResourceBundleMessageSource bundle = new ReloadableResourceBundleMessageSource();
        bundle.setBasename("/resources");
        bundle.setFallbackToSystemLocale(false);
        return bundle;
    }

    @Bean
    public UIFactory uiFactory() {
        return new UIFactory();
    }

    @Bean
    public ScheduledExecutorService uiTimer() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads / 2 + 1);
    }

    @Bean
    @Lazy
    public TextSizingUtility textSizingUtility() {
        return new TextSizingUtility();
    }

    @Bean
    @Scope(value="prototype")
    public ICityPlayerProxyJFX cityPlayerProxy(ICity city, IHumanPlayer player, IShip ship) {
        return new CityPlayerProxyJFX(city, player, (INavigableVessel)ship);
    }

    @Bean
    @Scope(value="prototype")
    public CheatMenu cheatMenu(ICheatCommand command, ReadOnlyDoubleProperty parentWidth) {
        return new CheatMenu(command, parentWidth);
    }

    @Bean
    @Scope(value="prototype")
    public BarrelIconView barrelIconView(IImageLoader imgLoader) {
        return new BarrelIconView(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public BaleIconView baleIconView(IImageLoader imgLoader) {
        return new BaleIconView(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public BarrelAmount barrelAmount(IImageLoader imgLoader) {
        return new BarrelAmount(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public BaleAmount baleAmount(IImageLoader imgLoader) {
        return new BaleAmount(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public BarrelAmountAlwaysVisible barrelAmountAlwaysVisible(IImageLoader imgLoader) {
        return new BarrelAmountAlwaysVisible(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public BaleAmountAlwaysVisible baleAmountAlwaysVisible(IImageLoader imgLoader) {
        return new BaleAmountAlwaysVisible(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public NavigationSkillAlwaysVisible navigationSkillAlwaysVisible(IImageLoader imgLoader) {
        return new NavigationSkillAlwaysVisible(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public FightingSkillAlwaysVisible fightingSkillAlwaysVisible(IImageLoader imgLoader) {
        return new FightingSkillAlwaysVisible(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public TradingSkillAlwaysVisible tradingSkillAlwaysVisible(IImageLoader imgLoader) {
        return new TradingSkillAlwaysVisible(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public CoinIconView coinIconView(IImageLoader imgLoader) {
        return new CoinIconView(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public CoinPrice coinPrice(IImageLoader imgLoader) {
        return new CoinPrice(imgLoader);
    }

    @Bean
    @Scope(value="prototype")
    public CoinPriceAlwaysVisible coinPriceAlwaysVisible(IImageLoader imgLoader) {
        return new CoinPriceAlwaysVisible(imgLoader);
    }
}

