/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class DefaultSimpleDialog
extends CloseButtonDialog {
    @Autowired
    private DialogUtil dialogHelper;
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    protected Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    private final VBox box = new VBox();

    public DefaultSimpleDialog() {
        this(false);
    }

    public DefaultSimpleDialog(boolean withoutTitle) {
        this.box.setLayoutX(30.0);
        if (withoutTitle) {
            this.box.setLayoutY(47.0);
        } else {
            this.box.setLayoutY(127.0);
        }
        this.getContent().add((Object)this.box);
    }

    public DefaultSimpleDialog(int spacing) {
        this(false);
        this.box.setSpacing((double)spacing);
    }

    public DecoratedText addDecoratedText(String textKey, String id, Object ... textParameters) {
        String template = this.messageSource.getMessage(textKey, textParameters, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        this.addNode((Node)text, id);
        return text;
    }

    public void addNode(Node node, String id) {
        this.box.getChildren().add((Object)node);
        if (id != null) {
            node.setId(id);
        } else {
            node.setId("");
        }
    }

    public void addDecoratedText(String textKey, String id, Pos alignment, Object ... textParameters) {
        String template = this.messageSource.getMessage(textKey, textParameters, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        this.addNode((Node)text, id, alignment);
    }

    public void addNode(Node node, String id, Pos alignment) {
        block12: {
            block13: {
                block11: {
                    if (alignment == Pos.CENTER_LEFT) {
                        this.addNode(node, id);
                        return;
                    }
                    if (id != null) {
                        node.setId(id);
                    } else {
                        node.setId("");
                    }
                    if (!(node instanceof Pane)) break block11;
                    switch (alignment) {
                        case CENTER: {
                            this.addNode((Node)this.dialogHelper.center((Pane)node), null);
                            break block12;
                        }
                        case CENTER_RIGHT: {
                            this.addNode((Node)this.dialogHelper.right((Pane)node), null);
                            break block12;
                        }
                        default: {
                            throw new IllegalArgumentException("Alignment '" + alignment + "' is not supported");
                        }
                    }
                }
                if (!(node instanceof Control)) break block13;
                switch (alignment) {
                    case CENTER: {
                        this.addNode((Node)this.dialogHelper.center((Control)node), null);
                        break block12;
                    }
                    case CENTER_RIGHT: {
                        this.addNode((Node)this.dialogHelper.right((Control)node), null);
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Alignment '" + alignment + "' is not supported");
                    }
                }
            }
            throw new IllegalArgumentException("Can only add Panes and Controlls in a layouted form");
        }
    }

    public void addVerticalSpacer(int heigth) {
        this.box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(heigth));
    }

    public OpenPatricianLargeWaxButton addActionButton(String textKey, String id) {
        OpenPatricianLargeWaxButton button = new OpenPatricianLargeWaxButton(this.messageSource.getMessage(textKey, new Object[0], this.locale.getCurrentLocal()));
        button.setId(id);
        int actionButtonX = 197;
        button.setLayoutX(197.0);
        button.setLayoutY(603.0);
        this.getContent().add((Object)button);
        return button;
    }

    public void clearContent() {
        this.box.getChildren().clear();
    }

    public void remove(Node node) {
        this.box.getChildren().remove((Object)node);
    }
}

