/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.TabelViewDialog;
import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.BaleAmount;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class WareInStockDialog
extends TabelViewDialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private static final IntegerBinding ONE_INT_BINDING = new IntegerBinding(){

        protected int computeValue() {
            return 1;
        }
    };
    private final ICityPlayerProxyJFX city;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ComputablePriceV2 computablePrice;
    @Autowired
    private ApplicationContext context;

    public WareInStockDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WareInStockDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"The trading office must be present.");
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WareInStockDialog.stockInCity", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WareInStockDialog.fromCity", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WareInStockDialog.toCity", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{100, 100, 100, 100});
        for (EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName((IWare)ware)));
            AmountablePrice available = this.city.getCity().getWare((IWare)ware);
            ReadOnlyIntegerProperty storedAmountProperty = available.amountProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = (BarrelAmount)this.context.getBean(BarrelAmount.class);
                barrelAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = (BaleAmount)this.context.getBean(BaleAmount.class);
                baleAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            CoinPriceAlwaysVisible buyPrice = (CoinPriceAlwaysVisible)this.context.getBean(CoinPriceAlwaysVisible.class);
            buyPrice.amountProperty().bind((ObservableValue)this.buyPrice((IWare)ware, storedAmountProperty));
            row.add((ITableCell)new ControlTableCell((Node)buyPrice));
            CoinPriceAlwaysVisible sellPrice = (CoinPriceAlwaysVisible)this.context.getBean(CoinPriceAlwaysVisible.class);
            sellPrice.amountProperty().bind((ObservableValue)this.sellPrice((IWare)ware, storedAmountProperty));
            row.add((ITableCell)new ControlTableCell((Node)sellPrice));
            model.add(row);
        }
        return model;
    }

    private StringBinding buyPrice(final IWare ware, final ReadOnlyIntegerProperty availableAmount) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount});
            }

            protected String computeValue() {
                return String.valueOf(WareInStockDialog.this.computablePrice.buyPrice((ITradable)ware, availableAmount, ONE_INT_BINDING));
            }
        };
    }

    private StringBinding sellPrice(final IWare ware, final ReadOnlyIntegerProperty availableAmount) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount});
            }

            protected String computeValue() {
                return String.valueOf(WareInStockDialog.this.computablePrice.sellPrice((ITradable)ware, availableAmount, ONE_INT_BINDING));
            }
        };
    }
}

