/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.DonationRequestState;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class DonationRequestDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private ClientViewState clientViewState;
    private final DonationRequestState state;

    public DonationRequestDialog(DonationRequestState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String date = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), date});
        this.addVerticalSpacer(20);
        if (this.state.isGenderMale()) {
            this.addDecoratedText("letter.salutation.male", "salutationMale", this.state.getToLastName());
        } else {
            this.addDecoratedText("letter.salutation.female", "salutationFemale", this.state.getToLastName());
        }
        this.addVerticalSpacer(20);
        this.addDecoratedText(this.state.getMessageKey(), "content", this.state.getAmount());
        OpenPatricianLargeWaxButton button = this.addActionButton("ch.sahits.game.openpatrician.display.dialog.events.DonationRequestDialog.donate", "acceptBtn");
        button.setId("acceptBtn");
        if (this.state.isAccepted()) {
            button.setDisable(true);
        } else {
            button.setOnAction(event -> {
                this.clientViewState.getPlayer().getCompany().updateCash((long)(-this.state.getAmount()));
                this.state.setAccepted(true);
                this.executeOnCloseButtonClicked();
            });
        }
    }
}

