/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.guild;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.clientserverinterface.service.GuildService;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.event.data.AuctionBidLevel;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.ItemNavigator;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.javafx.service.ItemNavigatorLabelWrapperFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ModelFactory;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.guild.EBidLevel;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IBuildingAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class AuctionGuildDialog
extends CloseButtonDialog {
    private static final Logger log = LoggerFactory.getLogger(AuctionGuildDialog.class);
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private GuildService guildService;
    @Autowired
    private Date date;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private ItemNavigatorLabelWrapperFactory itemWrapperFactory;
    @Autowired
    private DateService dateService;
    @Autowired
    private ModelFactory modelFactory;
    @Autowired
    private DialogUtil dialogHelper;
    @ObjectPropertyType(value=EBidLevel.class)
    private ObjectProperty<EBidLevel> currentBidLevel;
    private OpenPatricianLargeWaxButton auctionBtn;
    private VBox box;

    public AuctionGuildDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        IAuction nextAuction;
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IGuild guild = (IGuild)this.guildList.findGuild(this.city.getCity()).get();
        List auctions = guild.getAuctions();
        this.box = new VBox();
        if (auctions.isEmpty()) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.noAuction", new Object[0], this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("noAuction");
            this.box.getChildren().add((Object)text);
        } else {
            LocalDateTime date = ((IAuction)auctions.get(0)).getAuctionDate();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.nextAuction", new Object[]{this.modelTranslations.toDisplayString(date)}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("nextAuction");
            this.box.getChildren().add((Object)text);
        }
        this.box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(20));
        this.addControlsForOwnShipAuction(guild, this.box);
        if (!auctions.isEmpty() && this.dateService.isToday((nextAuction = (IAuction)auctions.get(0)).getAuctionDate())) {
            this.addAuctionDescription(this.box, nextAuction);
            this.currentBidLevel = new SimpleObjectProperty((Object)nextAuction.getBidLevel());
            this.addCurrentBidInformation(this.box, nextAuction, this.box.getChildren().size());
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.nextBid", new Object[]{nextAuction.getCurrentBid() + 500}, this.locale.getCurrentLocal());
            this.auctionBtn = new OpenPatricianLargeWaxButton(s);
            this.auctionBtn.getStyleClass().add((Object)"actionButton");
            this.auctionBtn.setId("auctionButton");
            Pane centeredAuction = this.dialogHelper.center((Control)this.auctionBtn);
            this.auctionBtn.setOnAction(event -> {
                try {
                    this.auctionBtn.setDisable(true);
                    EBidLevel current = (EBidLevel)this.currentBidLevel.get();
                    EBidLevel next = nextAuction.getBiddingPlayer() == null ? EBidLevel.INITIAL : this.calculateNextBidLevel(current);
                    this.clientEventBus.post((Object)new AuctionBidLevel(current, next, (IPlayer)this.city.getPlayer(), nextAuction));
                }
                catch (RuntimeException e) {
                    log.error("Failed to auction ship", (Throwable)e);
                }
            });
            this.box.getChildren().add((Object)centeredAuction);
            this.addBidLevelCountDown(this.box, nextAuction, this.box.getChildren().size());
            this.clientEventBus.register((Object)this);
        }
        this.box.setLayoutX(50.0);
        this.box.setLayoutY(127.0);
        this.getContent().addAll((Object[])new Node[]{this.box});
    }

    private void addBidLevelCountDown(VBox box, IAuction nextAuction, int index) {
        String template = this.getBidLevelTemplate(nextAuction);
        DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
        dt.setId("bidLevel-" + this.currentBidLevel.get());
        box.getChildren().add(index, (Object)dt);
    }

    private void addCurrentBidInformation(VBox box, IAuction nextAuction, int index) {
        if (nextAuction.getBiddingPlayer() == null) {
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.noBid", new Object[0], this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
            dt.setId("noBid");
            box.getChildren().add(index, (Object)dt);
        } else {
            IPlayer bidder = nextAuction.getBiddingPlayer();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.currentBid", new Object[]{nextAuction.getCurrentBid(), bidder.getName(), bidder.getLastName()}, this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
            dt.setId("currentBid");
            box.getChildren().add(index, (Object)dt);
        }
        box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(20));
    }

    private void addAuctionDescription(VBox box, IAuction nextAuction) {
        if (nextAuction instanceof IBuildingAuction) {
            IBuilding building = ((IBuildingAuction)nextAuction).getAuctionedBuilding();
            IPlayer owner = (IPlayer)nextAuction.getOwner().get();
            String name = owner.getName() + " " + owner.getLastName();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.buildingAuction", new Object[]{this.modelTranslations.getLocalDisplayName(building), name}, this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
            dt.setId("buildingAuction");
            box.getChildren().add((Object)dt);
        } else {
            IShip ship = ((IShipAuction)nextAuction).getAuctionedShip();
            String name = ship.getOwner().getName() + " " + ship.getOwner().getLastName();
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.shipAuction", new Object[]{ship.getName(), name}, this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
            dt.setId("shipAuction");
            box.getChildren().add((Object)dt);
        }
        box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(20));
    }

    private void addControlsForOwnShipAuction(IGuild guild, VBox box) {
        String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.registerShip", new Object[0], this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setId("registerShip");
        box.getChildren().add((Object)text);
        if (this.city.getPlayersNavalVessels().isEmpty()) {
            template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.noShip", new Object[0], this.locale.getCurrentLocal());
            DecoratedText dt = this.textFactory.createDecoratedText(template, new HashMap());
            dt.setId("noShipInPort");
            box.getChildren().add((Object)dt);
        } else {
            ObservableList vessels = this.city.getPlayersNavalVessels();
            ArrayList<IShip> ships = new ArrayList<IShip>();
            for (INavigableVessel vessel : vessels) {
                if (!(vessel instanceof IShip)) continue;
                ships.add((IShip)vessel);
            }
            List wrappedList = this.itemWrapperFactory.createListForVessels(ships);
            ItemNavigator itemNavigator = new ItemNavigator(wrappedList);
            Group centerPane = this.dialogHelper.center((Pane)itemNavigator);
            box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(10));
            box.getChildren().add((Object)centerPane);
            box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(10));
            String s = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.auctionShip", new Object[0], this.locale.getCurrentLocal());
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s);
            action.getStyleClass().add((Object)"actionButton");
            action.setId("offerShip");
            Pane centeredButton = this.dialogHelper.center((Control)action);
            box.getChildren().add((Object)centeredButton);
            action.setOnAction(this.createAuctionShipAction(box, guild, text, (ItemNavigator<IShip>)itemNavigator, centerPane, centeredButton));
        }
        box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(20));
    }

    private EventHandler<MouseEvent> createAuctionShipAction(VBox container, IGuild guild, DecoratedText text, ItemNavigator<IShip> itemNavigator, Group centerPane, Pane action) {
        return event -> {
            try {
                container.getChildren().removeAll((Object[])new Node[]{text, centerPane, action});
                this.getContent().removeAll((Object[])new Node[]{text, centerPane, action});
                LocalDateTime auctionDate = this.date.getCurrentDate().plusDays(10L);
                auctionDate = this.guildService.cleanUpAuctionAndDetermineAuctionDate(auctionDate, guild);
                IShip ship = (IShip)itemNavigator.getCurrent();
                IShipAuction auction = this.modelFactory.createShipAuction(auctionDate, ship.getValue(), (IPlayer)this.city.getPlayer(), ship);
                this.city.getPlayer().removeShip(ship);
                guild.getAuctions().add(auction);
            }
            catch (RuntimeException e) {
                log.error("Failed to set ship for auctioning", (Throwable)e);
            }
        };
    }

    private EBidLevel calculateNextBidLevel(EBidLevel current) {
        EBidLevel next;
        switch (current) {
            case INITIAL: {
                next = EBidLevel.ONE;
                break;
            }
            case ONE: {
                next = EBidLevel.TWO;
                break;
            }
            case TWO: {
                next = EBidLevel.DONE;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state: " + current);
            }
        }
        return next;
    }

    private String getBidLevelTemplate(IAuction auction) {
        switch ((EBidLevel)this.currentBidLevel.get()) {
            case INITIAL: {
                return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.noBid", new Object[0], this.locale.getCurrentLocal());
            }
            case ONE: {
                return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.first", new Object[0], this.locale.getCurrentLocal());
            }
            case TWO: {
                return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.second", new Object[0], this.locale.getCurrentLocal());
            }
            case DONE: {
                IPlayer newOwner = auction.getBiddingPlayer();
                return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.sold", new Object[]{newOwner.getName(), newOwner.getLastName()}, this.locale.getCurrentLocal());
            }
        }
        throw new IllegalStateException("Unhandled state: " + this.currentBidLevel.get());
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.unregister((Object)this);
        super.executeOnCloseButtonClicked();
    }

    @Subscribe
    public void handleBidLevelChange(AuctionBidLevel change) {
        int index;
        this.currentBidLevel.setValue((Object)change.getNewLevel());
        if (!change.getBidder().equals(this.city.getPlayer())) {
            this.auctionBtn.setDisable(false);
        }
        if ((index = this.dialogHelper.removeById((Pane)this.box, "noBid")) < 0) {
            index = this.dialogHelper.removeById((Pane)this.box, "currentBid");
        }
        this.addCurrentBidInformation(this.box, change.getAuction(), index);
        index = this.dialogHelper.removeById((Pane)this.box, "bidLevel-" + change.getOldLevel());
        this.box.getChildren().remove(index);
        this.addBidLevelCountDown(this.box, change.getAuction(), index);
        if (change.getNewLevel() == EBidLevel.DONE) {
            this.auctionBtn.setVisible(false);
            this.clientEventBus.unregister((Object)this);
        } else {
            String label = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog.nextBid", new Object[]{change.getAuction().getCurrentBid() + 500}, this.locale.getCurrentLocal());
            this.auctionBtn.setText(label);
        }
    }
}

