/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.guild;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.GuildSettings;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.model.city.guild.ITradeAgreement;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.HashMap;
import java.util.List;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class GuildTradeAgreementDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildSettings guildSettings;
    @Autowired
    private ModelTranslations modelTranslations;

    public GuildTradeAgreementDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.GuildTradeAgreementDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IMediterreanMap map = this.guildSettings.getMediterreanMap();
        List agreements = map.getTradeAgreements((IPlayer)this.city.getPlayer());
        VBox box = new VBox(10.0);
        for (ITradeAgreement agreement : agreements) {
            String cityName = agreement.getTradeLocation().getName();
            String ware = this.modelTranslations.getLocalDisplayName((IWare)((EWare)agreement.getWare()));
            int price = agreement.getWareAndAmount().getAVGPrice();
            int amount = agreement.getWareAndAmount().getAmount();
            String till = this.modelTranslations.toDisplayString(agreement.getValidTill());
            String template = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.guild.GuildTradeAgreementDialog.agreement", new Object[]{cityName, amount, ware, price, till}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            box.getChildren().add((Object)text);
        }
        box.setLayoutX(30.0);
        box.setLayoutY(127.0);
        this.getContent().add((Object)box);
    }
}

