/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.AutomaticTradingOverviewDialog;
import ch.sahits.game.openpatrician.display.dialog.CityProductionConsumptionDialog;
import ch.sahits.game.openpatrician.display.dialog.CityShipTradeDialog;
import ch.sahits.game.openpatrician.display.dialog.CityStorageTradeDialog;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.GenericCloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.HistoryStandaloneDialog;
import ch.sahits.game.openpatrician.display.dialog.MessageConfigurationDialog;
import ch.sahits.game.openpatrician.display.dialog.PersonalDialog;
import ch.sahits.game.openpatrician.display.dialog.StorageOverviewDialog;
import ch.sahits.game.openpatrician.display.dialog.StorageShipTradeDialog;
import ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog;
import ch.sahits.game.openpatrician.display.dialog.WareInStockDialog;
import ch.sahits.game.openpatrician.display.dialog.WeaponInventoryDialog;
import ch.sahits.game.openpatrician.display.dialog.WeaponTransferDialog;
import ch.sahits.game.openpatrician.display.dialog.armory.HandWeaponDialog;
import ch.sahits.game.openpatrician.display.dialog.armory.ShipWeaponDialog;
import ch.sahits.game.openpatrician.display.dialog.church.ChurchExtensionDialog;
import ch.sahits.game.openpatrician.display.dialog.church.ChurchFeedingDialog;
import ch.sahits.game.openpatrician.display.dialog.church.ChurchGiftDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.AldermanOfficeDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.CityWallBuildingDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.HanseaticInfoDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.MeetingRoomDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.OutriggerNoticeDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.PublicNoticeDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.TownInfoDialog;
import ch.sahits.game.openpatrician.display.dialog.cityhall.TreasuryDialog;
import ch.sahits.game.openpatrician.display.dialog.guild.AuctionGuildDialog;
import ch.sahits.game.openpatrician.display.dialog.guild.GuildMediterraneanMapDialog;
import ch.sahits.game.openpatrician.display.dialog.guild.GuildMembersDialog;
import ch.sahits.game.openpatrician.display.dialog.guild.GuildTradeAgreementDialog;
import ch.sahits.game.openpatrician.display.dialog.guild.JoinGuildDialog;
import ch.sahits.game.openpatrician.display.dialog.loaner.LoanerGiveLoanDialog;
import ch.sahits.game.openpatrician.display.dialog.loaner.LoanerListLoansDialog;
import ch.sahits.game.openpatrician.display.dialog.loaner.LoanerPaybackDialog;
import ch.sahits.game.openpatrician.display.dialog.loaner.LoanerTakeLoanDialog;
import ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog;
import ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog;
import ch.sahits.game.openpatrician.display.dialog.ship.ShipInfoDialog;
import ch.sahits.game.openpatrician.display.dialog.ship.ShipListDialog;
import ch.sahits.game.openpatrician.display.dialog.ship.ShipWeaponInfoDialog;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipRepairDialogV2;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipyardConstructionDialogV2;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipyardConstructionListDialogV2;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipyardRenameDialogV2;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipyardRepairListDialogV2;
import ch.sahits.game.openpatrician.display.dialog.shipyard.ShipyardUpgradeDialogV2;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBurglarDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBuyerDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernCaptainDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernConcurrentDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernCourierDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernEscortDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernFugativeDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernInformantDialogPageOne;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernInformantDialogPageTwo;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernPatrolDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernPirateDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernPirateHunterDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernSailorDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernSmugglerDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernTraderDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernTransportTraderDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernTravelerDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernTreasureMapOwnerDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernWarehouseTenantDialog;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernWeaponsDealerDialog;
import ch.sahits.game.openpatrician.javafx.dialog.Dialog;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DialogFactory {
    @Autowired
    private ApplicationContext context;

    public Dialog getDialog(DialogTemplate template) {
        return (GenericCloseButtonDialog)this.context.getBean("genericCloseButtonDialog", new Object[]{template});
    }

    private HistoryStandaloneDialog getHistoryDialog(ICityPlayerProxyJFX cityProxy, String resourceName) {
        return (HistoryStandaloneDialog)this.context.getBean("historyStandaloneDialog", new Object[]{cityProxy, resourceName});
    }

    private String getHistoryResourceName(String name) {
        return "history." + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy) {
        switch (dialogType) {
            case PORT_CITY_TO_SHIP: {
                return (CityShipTradeDialog)this.context.getBean("cityShipTradeDialog", new Object[]{cityProxy});
            }
            case PORT_CITY_TO_STORAGE: {
                return (CityStorageTradeDialog)this.context.getBean("cityStorageTradeDialog", new Object[]{cityProxy});
            }
            case PORT_STORAGE_TO_SHIP: {
                return (StorageShipTradeDialog)this.context.getBean("storageShipTradeDialog", new Object[]{cityProxy});
            }
            case PORT_WEAPON: {
                return (Dialog)this.context.getBean(WeaponTransferDialog.class, new Object[]{cityProxy});
            }
            case TO_BALANCE: {
                return (TradeOfficeBalanceDialog)this.context.getBean("tradeOfficeBalanceDialog", new Object[]{cityProxy});
            }
            case TO_PERSONAL: {
                return (PersonalDialog)this.context.getBean("personalDialog", new Object[]{cityProxy});
            }
            case TO_CONSUMPTION_PRODUCTION: 
            case MB_CONSUMPTION_PRODUCTION: {
                return (CityProductionConsumptionDialog)this.context.getBean("cityProductionConsumptionDialog", new Object[]{cityProxy});
            }
            case TO_WEAPONS: {
                return (WeaponInventoryDialog)this.context.getBean("weaponInventoryDialog", new Object[]{cityProxy});
            }
            case TO_WAREHOUSES: {
                return (StorageOverviewDialog)this.context.getBean("storageOverviewDialog", new Object[]{cityProxy});
            }
            case TO_OFFICE_TRADING: {
                return (AutomaticTradingOverviewDialog)this.context.getBean("automaticTradingOverviewDialog", new Object[]{cityProxy});
            }
            case MB_STOCK_PRICES: {
                return (WareInStockDialog)this.context.getBean("wareInStockDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_CONSTRUCTION: {
                return (ShipyardConstructionDialogV2)this.context.getBean("shipyardConstructionDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_REPAIR: {
                return (ShipRepairDialogV2)this.context.getBean("shipRepairDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_CONSTRUCTION_LIST: {
                return (ShipyardConstructionListDialogV2)this.context.getBean("shipyardConstructionListDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_REPAIR_LIST: {
                return (ShipyardRepairListDialogV2)this.context.getBean("shipyardRepairListDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_UPGRADE: {
                return (ShipyardUpgradeDialogV2)this.context.getBean("shipyardUpgradeDialog", new Object[]{cityProxy});
            }
            case SHIPYARD_RENAME: {
                return (ShipyardRenameDialogV2)this.context.getBean("shipyardRenameDialog", new Object[]{cityProxy});
            }
            case ARMORY_HAND_WEAPONS: {
                return (HandWeaponDialog)this.context.getBean("handWeaponDialog", new Object[]{cityProxy});
            }
            case ARMORY_SHIP_WEAPONS: {
                return (ShipWeaponDialog)this.context.getBean("shipWeaponDialog", new Object[]{cityProxy});
            }
            case TAVERN_SAILORS: {
                return (TavernSailorDialog)this.context.getBean("tavernSailorDialog", new Object[]{cityProxy});
            }
            case TAVERN_CAPTAIN: {
                return (TavernCaptainDialog)this.context.getBean("tavernCaptainDialog", new Object[]{cityProxy});
            }
            case TAVERN_WEAPONS_DEALER: {
                return (TavernWeaponsDealerDialog)this.context.getBean("tavernWeaponsDealerDialog", new Object[]{cityProxy});
            }
            case TAVERN_PIRATE: {
                return (TavernPirateDialog)this.context.getBean("tavernPirateDialog", new Object[]{cityProxy});
            }
            case TAVERN_TRADER: {
                return (TavernTraderDialog)this.context.getBean("tavernTraderDialog", new Object[]{cityProxy});
            }
            case TAVERN_TRAVELER: {
                return (TavernTravelerDialog)this.context.getBean("tavernTravelerDialog", new Object[]{cityProxy});
            }
            case TAVERN_TREASUREMAP_OWNER: {
                return (TavernTreasureMapOwnerDialog)this.context.getBean("tavernTreasureMapOwnerDialog", new Object[]{cityProxy});
            }
            case TAVERN_INFORMANT_1: {
                return (TavernInformantDialogPageOne)this.context.getBean("tavernInformantDialogPageOne", new Object[]{cityProxy});
            }
            case TAVERN_INFORMANT_2: {
                return (TavernInformantDialogPageTwo)this.context.getBean("tavernInformantDialogPageTwo", new Object[]{cityProxy});
            }
            case TAVERN_SIDE_ROOM: {
                TavernState tavernState;
                TavernState tavernState2 = tavernState = cityProxy.getCity().getCityState().getTavernState();
                synchronized (tavernState2) {
                    ISideRoomPerson sideRoomPerson = (ISideRoomPerson)((List)tavernState.presentPersonsInSideRoomBinding().get()).get(0);
                    return this.createDialogForSideRoom(sideRoomPerson, cityProxy);
                }
            }
            case TAVERN_COURIER: {
                return (TavernCourierDialog)this.context.getBean("tavernCourierDialog", new Object[]{cityProxy});
            }
            case TAVERN_BURGLAR: {
                return (TavernBurglarDialog)this.context.getBean("tavernBurglarDialog", new Object[]{cityProxy});
            }
            case TAVERN_TRANSPORT_TRADER: {
                return (TavernTransportTraderDialog)this.context.getBean("tavernTransportTraderDialog", new Object[]{cityProxy});
            }
            case TAVERN_WAREHOUSE_TENANT: {
                return (TavernWarehouseTenantDialog)this.context.getBean("tavernWarehouseTenantDialog", new Object[]{cityProxy});
            }
            case TAVERN_SMUGGLER: {
                return (TavernSmugglerDialog)this.context.getBean("tavernSmugglerDialog", new Object[]{cityProxy});
            }
            case TAVERN_PIRATE_HUNTER: {
                return (TavernPirateHunterDialog)this.context.getBean("tavernPirateHunterDialog", new Object[]{cityProxy});
            }
            case TAVERN_PATROL: {
                return (TavernPatrolDialog)this.context.getBean("tavernPatrolDialog", new Object[]{cityProxy});
            }
            case TAVERN_BUYER: {
                return (TavernBuyerDialog)this.context.getBean("tavernBuyerDialog", new Object[]{cityProxy});
            }
            case TAVERN_CONCURRENT: {
                return (TavernConcurrentDialog)this.context.getBean("tavernConcurrentDialog", new Object[]{cityProxy});
            }
            case TAVERN_ESCORTE: {
                return (TavernEscortDialog)this.context.getBean("tavernEscortDialog", new Object[]{cityProxy});
            }
            case TAVERN_FUGATIVE: {
                return (TavernFugativeDialog)this.context.getBean("tavernFugativeDialog", new Object[]{cityProxy});
            }
            case LOANER_TAKE: {
                return (LoanerTakeLoanDialog)this.context.getBean("loanerTakeLoanDialog", new Object[]{cityProxy});
            }
            case LOANER_GIVE: {
                return (LoanerGiveLoanDialog)this.context.getBean("loanerGiveLoanDialog", new Object[]{cityProxy});
            }
            case LOANER_REPAY: {
                return (LoanerPaybackDialog)this.context.getBean("loanerPaybackDialog", new Object[]{cityProxy});
            }
            case LOANER_LIST: {
                return (LoanerListLoansDialog)this.context.getBean("loanerListLoansDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_NOTICE: {
                return (PublicNoticeDialog)this.context.getBean("publicNoticeDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_OUTRIGGER: {
                return (OutriggerNoticeDialog)this.context.getBean("outriggerNoticeDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_TOWN_INFO: {
                return (TownInfoDialog)this.context.getBean("townInfoDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_TREASURY: {
                return (TreasuryDialog)this.context.getBean("treasuryDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_HANSEATIC_INFO: {
                return (HanseaticInfoDialog)this.context.getBean("hanseaticInfoDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_ALDERMAN_OFFICE: {
                return (AldermanOfficeDialog)this.context.getBean("aldermanOfficeDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_MEETING_ROOM: {
                return (MeetingRoomDialog)this.context.getBean("meetingRoomDialog", new Object[]{cityProxy});
            }
            case CITY_HALL_CITY_WALL: {
                return (CityWallBuildingDialog)this.context.getBean("cityWallBuildingDialog", new Object[]{cityProxy});
            }
            case CHURCH_FEED: {
                return (ChurchFeedingDialog)this.context.getBean("churchFeedingDialog", new Object[]{cityProxy});
            }
            case CHURCH_GIFT: {
                return (ChurchGiftDialog)this.context.getBean("churchGiftDialog", new Object[]{cityProxy});
            }
            case CHURCH_EXTENSION: {
                return (ChurchExtensionDialog)this.context.getBean("churchExtensionDialog", new Object[]{cityProxy});
            }
            case SHIP_CONVOY: {
                return (ConvoyDialog)this.context.getBean("convoyDialog", new Object[]{cityProxy});
            }
            case GUILD_JOIN: {
                return (JoinGuildDialog)this.context.getBean("joinGuildDialog", new Object[]{cityProxy});
            }
            case GUILD_MEMBERS: {
                return (GuildMembersDialog)this.context.getBean("guildMembersDialog", new Object[]{cityProxy});
            }
            case GUILD_AUCTION: {
                return (AuctionGuildDialog)this.context.getBean("auctionGuildDialog", new Object[]{cityProxy});
            }
            case GUILD_MEDITERREAN: {
                return (GuildMediterraneanMapDialog)this.context.getBean("guildMediterraneanMapDialog", new Object[]{cityProxy});
            }
            case GUILD_TRADE_AGREEMENT: {
                return (GuildTradeAgreementDialog)this.context.getBean("guildTradeAgreementDialog", new Object[]{cityProxy});
            }
            case CITY_HISTORY: {
                String resourceName = this.getHistoryResourceName(cityProxy.getCity().getNameTemplate());
                return this.getHistoryDialog(cityProxy, resourceName);
            }
            case SHIP_WEAPON_INFO: {
                return (ShipWeaponInfoDialog)this.context.getBean("shipWeaponInfoDialog", new Object[]{cityProxy});
            }
            case SHIP_INFO: {
                return (Dialog)this.context.getBean(ShipInfoDialog.class, new Object[]{cityProxy});
            }
            case SHIP_LIST: {
                return (Dialog)this.context.getBean(ShipListDialog.class, new Object[]{cityProxy});
            }
            case MESSAGE_CONFIGURATION: {
                return (Dialog)this.context.getBean(MessageConfigurationDialog.class, new Object[]{cityProxy});
            }
        }
        throw new RuntimeException("Not yet implemented: " + dialogType);
    }

    public CloseButtonDialog getDialog(IDialogState state) {
        return (CloseButtonDialog)this.context.getBean(state.getDialogBeanName(), new Object[]{state});
    }

    public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy, IConvoy convoy, IShip ship) {
        switch (dialogType) {
            case LEAVE_CONVOY: {
                return (LeaveConvoyDialog)this.context.getBean("leaveConvoyDialog", new Object[]{cityProxy, convoy, ship});
            }
        }
        throw new RuntimeException("Not yet implemented: " + dialogType);
    }

    private Dialog createDialogForSideRoom(ISideRoomPerson sideRoomPerson, ICityPlayerProxyJFX cityProxy) {
        if (sideRoomPerson instanceof ICourier) {
            return (TavernCourierDialog)this.context.getBean("tavernCourierDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IThieve) {
            return (TavernBurglarDialog)this.context.getBean("tavernBurglarDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof ITransportTrader) {
            return (TavernTransportTraderDialog)this.context.getBean("tavernTransportTraderDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IWarehouseTenant) {
            return (TavernWarehouseTenantDialog)this.context.getBean("tavernWarehouseTenantDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof ISmuggler) {
            return (TavernSmugglerDialog)this.context.getBean("tavernSmugglerDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IPirateHunter) {
            return (TavernPirateHunterDialog)this.context.getBean("tavernPirateHunterDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IPatrol) {
            return (TavernPatrolDialog)this.context.getBean("tavernPatrolDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IBuyer) {
            return (TavernBuyerDialog)this.context.getBean("tavernBuyerDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IConcurrent) {
            return (TavernConcurrentDialog)this.context.getBean("tavernConcurrentDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IEscorte) {
            return (TavernEscortDialog)this.context.getBean("tavernEscortDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof IFugitive) {
            return (TavernFugativeDialog)this.context.getBean("tavernFugativeDialog", new Object[]{cityProxy});
        }
        if (sideRoomPerson instanceof ITreasureMapOwner) {
            return (TavernTreasureMapOwnerDialog)this.context.getBean("tavernTreasureMapOwnerDialog", new Object[]{cityProxy});
        }
        throw new RuntimeException("Not yet implemented: " + sideRoomPerson.getClass().getName());
    }
}

