/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.service;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.property.MapProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TavernDialogUtil {
    public void stopTalkingToPerson(TavernState tavernState, IPlayer player) {
        MapProperty iPersonIPlayerMapProperty = tavernState.talkingToProperty();
        Map talkTo = (Map)iPersonIPlayerMapProperty.get();
        Iterator iterator = talkTo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((IPlayer)entry.getValue()).equals(player)) continue;
            iterator.remove();
        }
    }

    public boolean noShipWithEnoughCapacityAvailable(ICityPlayerProxyJFX city, int amountInBale) {
        if (city.getPlayersShips().isEmpty()) {
            return true;
        }
        for (IShip ship : city.getPlayersShips()) {
            if (ship.getCapacity() < amountInBale * 10) continue;
            return false;
        }
        return true;
    }
}

