/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.shipyard;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.openpatrician.event.data.ShipyardOrderRepair;
import ch.sahits.game.openpatrician.javafx.control.BarrelAmount;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.ITableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipRepairDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipRepairDialogV2
extends BaseShipyardDialog {
    private static final Logger log = LoggerFactory.getLogger(ShipRepairDialogV2.class);
    @ObjectPropertyType(value=IShip.class)
    private ObjectProperty<IShip> currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipService shipService;
    @Autowired
    private ApplicationContext context;

    public ShipRepairDialogV2(ICityPlayerProxyJFX city) {
        super(city);
        if (city.getActiveShip() instanceof IShip) {
            IShip ship = (IShip)city.getActiveShip();
            this.currentShip.setValue((Object)ship);
        }
        if (this.currentShip.get() != null) {
            for (int i = 0; i < this.shipTypes.length; ++i) {
                if (this.shipTypes[i] != ((IShip)this.currentShip.get()).getShipType()) continue;
                this.currentShipTypeIndexProperty().set(i);
                break;
            }
        } else {
            this.currentShipTypeIndexProperty().set(0);
        }
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipRepairDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        this.enablePreviousNext = this.dialogUtil.enableShipCatalogueForShips((ObservableList<IShip>)this.city.getPlayersShips());
    }

    @Override
    protected void initializeRequirements() {
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return mouseEvent -> {
            try {
                IShip ship = (IShip)this.currentShip.get();
                ship.setAvailable(false);
                this.city.leave((INavigableVessel)ship);
                ShipyardOrderRepair event = new ShipyardOrderRepair(this.getCity().getCityState().getShipyardState(), (IShip)this.currentShip.get(), this.city);
                this.clientServerEventBus.post((Object)event);
                this.getPlayer().getCompany().updateCash((long)(-this.calculateRepairCosts()));
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                log.error("Failed to order repair of ship", (Throwable)e);
            }
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipRepairDialogV2.repair", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected boolean hasShips() {
        if (this.city.getPlayersShips().size() > 0) {
            return this.city.getPlayersShips().stream().anyMatch(IShip::isAvailable);
        }
        return false;
    }

    @Override
    protected Group createFooterText() {
        int costs = this.calculateRepairCosts();
        Group g = new Group();
        String t = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", costs);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(t, parameters);
        dt.setId("totalPrice");
        g.getChildren().add((Object)dt);
        g.setId("footerText");
        return g;
    }

    private int calculateRepairCosts() {
        return this.shipService.calculateRepairCosts(this.getCity(), (IShip)this.currentShip.get());
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(1);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{200});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(((IShip)this.currentShip.get()).getName()));
        model.add(row);
        return model;
    }

    @Override
    protected Table createTopTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = (BarrelAmount)this.context.getBean(BarrelAmount.class);
        capacityAmount.setAmount(Integer.valueOf(((IShip)this.currentShip.get()).getLoadableSpace()));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(100 - ((IShip)this.currentShip.get()).getDamage())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(((IShip)this.currentShip.get()).getNumberOfSailors())));
        row.add((ITableCell)new StaticTextTableCell("1"));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return (long)ShipRepairDialogV2.this.calculateRepairCosts() < ShipRepairDialogV2.this.getPlayer().getCompany().getCash();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return event -> {
            this.dialogUtil.createNextActionForShips((ObservableList<IShip>)this.city.getPlayersShips(), this.currentShip).handle(event);
            this.selectionChanged();
        };
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return event -> {
            this.dialogUtil.createPreviousActionForShips((ObservableList<IShip>)this.city.getPlayersShips(), this.currentShip).handle(event);
            this.selectionChanged();
        };
    }

    @Override
    protected BooleanProperty disableNavigation() {
        return new SimpleBooleanProperty(this.city.getPlayersShips().size() <= 1);
    }

    @Override
    protected String getTitleText() {
        return ((IShip)this.currentShip.get()).getName();
    }

    @Override
    protected void selectionChanged() {
        super.selectionChanged();
        Group footerText = this.createFooterText();
        footerText.setLayoutX(50.0);
        footerText.setLayoutY(454.0);
        Iterator iterator = this.getContent().iterator();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (!"footerText".equals(child.getId())) continue;
            iterator.remove();
            break;
        }
        this.getContent().add((Object)footerText);
    }
}

