/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.impl.AttackListener;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.event.data.ShipEntersPortEvent;
import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class NextPatrolStation
extends ShipEntersPortEventListener {
    private final PatrolInternalState state;
    private final IPlayer player;
    private final LocalDateTime deadline;
    private final AttackListener atackListener;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private ClientTaskFactory taskFactory;
    @Autowired
    @XStreamOmitField
    private EventHandlerFactory eventHandlerFactory;

    public NextPatrolStation(INavigableVessel ship, ICity city, PatrolInternalState state, IPlayer player, LocalDateTime deadline, AttackListener atackListener) {
        super(ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        this.atackListener = atackListener;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        LocalDateTime now = this.date.getCurrentDate();
        if (now.isAfter(this.deadline)) {
            if (this.player instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", new Object[0]);
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)msg));
            }
            this.clientServerEventBus.unregister((Object)this);
            this.clientServerEventBus.unregister((Object)this.atackListener);
        }
    }

    public boolean execute(ICity city) {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium() + this.state.getNumberOfAttacks() * this.state.getBonusPerAttack();
            if (this.player instanceof IHumanPlayer) {
                this.player.getCompany().updateCash((long)premium);
            } else {
                this.player.getCompany().updateCashDirectly((long)premium);
            }
            if (this.player instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.event.handler.impl.NextPatrolStation.premium", new Object[]{premium});
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)msg));
            }
            this.clientServerEventBus.unregister((Object)this.atackListener);
            this.unregisterEventBus();
            this.clientServerEventBus.unregister((Object)this.atackListener);
        } else {
            ICity next = nextCity.get();
            int minutes = this.rnd.nextInt(600);
            LocalDateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation.title").messageKey("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation").messageArgs(new Object[]{this.getShip().getName(), next.getName()}).build();
            this.taskFactory.getPostponedDisplayDialogMessage(postMessage, EMessageCategory.TRADE, template);
            LocalDateTime deadline = this.date.getCurrentDate().plusDays(6L);
            this.eventHandlerFactory.getNextPatrolStation(this.getShip(), this.state.nextDestination().get(), this.state, this.player, deadline, this.atackListener);
        }
        return true;
    }
}

