/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.display.event.task.IDelayedCaughtAction;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.CityCreditor;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class DelayedCaughtAction
extends TimedTask
implements IDelayedCaughtAction {
    private final IPlayer player;
    private final ICity city;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    private LoanerList loaners;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    public DelayedCaughtAction(IPlayer player, ICity city) {
        this.player = player;
        this.city = city;
    }

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(5L));
    }

    @Override
    public void run() {
        int penalty = (int)Math.abs((double)this.player.getCompany().getCash() / (200.0 * this.rnd.nextDouble()));
        DisplayMessage msg = new DisplayMessage(EMessageCategory.OFFICIAL, "ch.sahits.game.graphic.event.task.DelayedCaughtAction.message", new Object[]{penalty});
        this.clientEventBus.post((Object)msg);
        ILoaner loaner = this.loaners.getLoaner(this.city);
        Debt debt = Debt.builder().amount(penalty).dueDate(this.date.getCurrentDate().plusMonths(1L)).interest(0.0).loanTakeOut(this.date.getCurrentDate()).debitor((ICitizen)this.player).creditor((ICreditor)new CityCreditor()).build();
        loaner.addDebt((IDebt)debt);
    }

    public String toString() {
        return "DelayedCaughtAction{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + this.player.getUuid() + " " + this.player.getName() + " " + this.player.getLastName() + ", city=" + this.city.getName() + "}";
    }
}

