/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WarehouseTenantPayTimedTask
extends TimedTask {
    private IPlayer player;
    private IWarehouseTenant tenant;

    public WarehouseTenantPayTimedTask(IPlayer player, IWarehouseTenant tenant, LocalDateTime deadLine) {
        this.player = player;
        this.tenant = tenant;
        this.setExecutionTime(deadLine);
    }

    public void run() {
        if (this.player instanceof IHumanPlayer) {
            this.player.getCompany().updateCash((long)this.tenant.getRentPerWeek());
        } else {
            this.player.getCompany().updateCashDirectly((long)this.tenant.getRentPerWeek());
        }
    }

    public String toString() {
        return "WarehouseTenantPayTimedTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + this.player.getUuid() + " " + this.player.getName() + " " + this.player.getLastName() + ", tenant=" + this.tenant.getName() + "}";
    }
}

