/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.display.javafx.action.UserActions;
import ch.sahits.game.openpatrician.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassCategory(value={EClassCategory.HANDLER})
public class BuyJFXProxyAction
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(BuyJFXProxyAction.class);
    private final ITransferableJFX dialog;
    @MapType(key=EDialogType.class, value=Runnable.class)
    private final HashMap<EDialogType, Runnable> actionMap;

    public BuyJFXProxyAction(IWare ware, ITransferableJFX dialog, UserActions actionFactory) {
        this.dialog = dialog;
        this.actionMap = new HashMap();
        this.actionMap.put(EDialogType.PORT_CITY_TO_SHIP, actionFactory.city2ShipAction(ware, dialog));
        this.actionMap.put(EDialogType.PORT_CITY_TO_STORAGE, actionFactory.city2StorageAction(ware, dialog));
        this.actionMap.put(EDialogType.PORT_STORAGE_TO_SHIP, actionFactory.ship2StorageAction(ware, dialog));
    }

    @Override
    public void run() {
        try {
            Runnable action = this.actionMap.get(this.dialog.getDialogType());
            if (action == null) {
                log.error("No action defined for dialog transfer type: " + this.dialog.getDialogType());
            } else {
                action.run();
            }
        }
        catch (RuntimeException e) {
            log.error("Failed to buy wares", (Throwable)e);
        }
    }
}

