/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
class Ship2StorageJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;
    @Autowired
    private TradeService tradeService;

    public Ship2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel ship = this.transfer.getVessel();
        AmountablePrice amountable = ship.getWare(this.ware);
        int availableAmountShip = amountable.getAmount();
        IPlayer player = this.transfer.getPlayer();
        ICity city = this.transfer.getCity();
        Optional optOffice = player.findTradingOffice(city);
        if (availableAmountShip > 0 && optOffice.isPresent()) {
            HashMap<IWare, Integer> amounts = new HashMap<IWare, Integer>();
            amounts.put(this.ware, this.transfer.getAmount(availableAmountShip));
            this.tradeService.transferFromVesselToStorage(ship, player, city, amounts);
        }
    }
}

