/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.GenericTriple;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.IDoubleSelectableCheatCommand;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCode;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class AddWeaponToShipCheat
implements IDoubleSelectableCheatCommand {
    private static final Logger log = LoggerFactory.getLogger(AddWeaponToShipCheat.class);
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.W;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.AddWeaponToShipCheat.desc";
    @ListType(value=GenericTriple.class)
    private final List<GenericTriple<String>> firstOptions = new ArrayList<GenericTriple<String>>();
    @ListType(value=GenericTriple.class)
    private final List<GenericTriple<String>> secondOptions = new ArrayList<GenericTriple<String>>();
    private GenericTriple<String> selectedFirstOption;
    private GenericTriple<String> selectedSecondOption;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;

    @PostConstruct
    private void init() {
        EWeapon[] weapons;
        for (EWeapon weapon : weapons = new EWeapon[]{EWeapon.BALLISTA_SMALL, EWeapon.BALLISTA_BIG, EWeapon.TREBUCHET_SMALL, EWeapon.TREBUCHET_BIG, EWeapon.BOMBARD, EWeapon.CANNON}) {
            String display = this.messageSource.getMessage(weapon.name(), new Object[0], this.locale.getCurrentLocal());
            this.firstOptions.add((GenericTriple<String>)new GenericTriple((Object)String.valueOf(weapon.ordinal()), (Object)weapon.name(), (Object)display));
        }
        this.selectedFirstOption = this.firstOptions.get(0);
    }

    public void setupModel() {
        ClientViewState viewState = (ClientViewState)this.context.getBean(ClientViewState.class);
        if (viewState.getCurrentCityProxy().isPresent()) {
            ObservableList ships = viewState.getCurrentCityProxy().get().getPlayersShips();
            for (IShip ship : ships) {
                this.secondOptions.add((GenericTriple<String>)new GenericTriple((Object)ship.getUuid(), (Object)ship.getUuid(), (Object)ship.getName()));
            }
            if (!ships.isEmpty()) {
                this.selectedSecondOption = this.secondOptions.get(0);
            }
        }
    }

    public void execute() {
        ClientViewState viewState = (ClientViewState)this.context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        List fleet = player.getFleet();
        IShip ship = null;
        for (IShip s : fleet) {
            if (!s.getUuid().equals(this.selectedSecondOption.getFirst())) continue;
            ship = s;
            break;
        }
        if (ship != null) {
            EWeapon weapon = EWeapon.valueOf((String)((String)this.selectedFirstOption.getSecond()));
            ShipService shipService = (ShipService)this.context.getBean(ShipService.class);
            shipService.placeWeapon(weapon, ship);
            log.debug("Cheated one cannon onto the active ship: " + ship.getName());
        }
    }

    public KeyCode getControlKey() {
        return this.controlKey;
    }

    public KeyCode getKey() {
        return this.key;
    }

    public String getDescriptionTextKey() {
        return this.descriptionTextKey;
    }

    public List<GenericTriple<String>> getFirstOptions() {
        return this.firstOptions;
    }

    public List<GenericTriple<String>> getSecondOptions() {
        return this.secondOptions;
    }

    public GenericTriple<String> getSelectedFirstOption() {
        return this.selectedFirstOption;
    }

    public GenericTriple<String> getSelectedSecondOption() {
        return this.selectedSecondOption;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setSelectedFirstOption(GenericTriple<String> selectedFirstOption) {
        this.selectedFirstOption = selectedFirstOption;
    }

    public void setSelectedSecondOption(GenericTriple<String> selectedSecondOption) {
        this.selectedSecondOption = selectedSecondOption;
    }
}

