/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.model.cheat;

import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.cheat.ICheatCommand;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.CityHall;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import javafx.scene.input.KeyCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BecomeMayorCheat
implements ICheatCommand {
    private final KeyCode controlKey = KeyCode.CONTROL;
    private final KeyCode key = KeyCode.M;
    private final String descriptionTextKey = "ch.sahits.game.openpatrician.display.model.cheat.BecomeMayorCheat.desc";
    @Autowired
    private ApplicationContext context;

    public void execute() {
        ClientViewState viewState = (ClientViewState)this.context.getBean(ClientViewState.class);
        IHumanPlayer player = viewState.getPlayer();
        ICity city = player.getHometown();
        CityHallList cityHalls = (CityHallList)this.context.getBean(CityHallList.class);
        CityHall cityHall = (CityHall)cityHalls.findCityHall(city).get();
        cityHall.setMayor((ICitizen)player);
        player.updateRank(ESocialRank.MAYOR);
    }

    public KeyCode getControlKey() {
        return this.controlKey;
    }

    public KeyCode getKey() {
        return this.key;
    }

    public String getDescriptionTextKey() {
        return this.descriptionTextKey;
    }

    public ApplicationContext getContext() {
        return this.context;
    }
}

