/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.loaders.IPolygonLoader;
import ch.sahits.game.openpatrician.display.scene.BaseStartupScene;
import ch.sahits.game.openpatrician.display.service.UIFactory;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2;
import ch.sahits.game.openpatrician.javafx.control.PaginationV2Builder;
import ch.sahits.game.openpatrician.javafx.event.MouseClickLocationEventHandler;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import ch.sahits.game.openpatrician.utilities.model.Text;
import ch.sahits.game.openpatrician.utilities.service.TextParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class HanseaticHistoryScene
extends BaseStartupScene {
    private static final Logger log = LoggerFactory.getLogger(HanseaticHistoryScene.class);
    private static final int FONT_SIZE = 36;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="resourceReference")
    private MessageSource resources;
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private TextParser textParser;
    @Autowired
    private IPolygonLoader polygonLoader;
    @Autowired
    private IFontLoader fontLoader;
    private Group labelShapes;
    private Group paginationGroup;

    public HanseaticHistoryScene() {
        super((Region)new Pane());
    }

    @Override
    protected String getStyleSheetFilename() {
        return "hanseaticHistory.css";
    }

    @PostConstruct
    private final void setUpScene() {
        Pane root = this.createBaseSceneLayout();
        Text text = this.getHistoryText();
        this.paginationGroup = new Group();
        this.paginationGroup.setManaged(false);
        Insets insets = new Insets(0.0, 10.0, 0.0, 70.0);
        Polygon backLabel = this.createPolygonShape("backButton");
        Polygon nextLabel = this.createPolygonShape("nextButton");
        Font defaultFont = this.fontLoader.createDefaultFont(36);
        Font headerFont = this.fontLoader.createDefaultFont(42);
        PaginationV2 pagination = PaginationV2Builder.create().backButtonLabel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.back", new Object[0], this.locale.getCurrentLocal())).nextButtonLabel(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.scene.CreditsScene.next", new Object[0], this.locale.getCurrentLocal())).text(text).contentMaxWidth(this.untransformedWidth).contentMaxHeight(this.untransformedHeight).padding(insets).navigationLabelFont(defaultFont).headerFont(headerFont).paragraphFont(defaultFont).centeredFont(defaultFont).backButtonNode((Node)backLabel).nextButtonNode((Node)nextLabel).firstLastPageAction((EventHandler)new BackToStartupScene()).build();
        AnchorPane ap = new AnchorPane();
        ap.getChildren().add((Object)this.paperScroll);
        AnchorPane.setBottomAnchor((Node)this.paperScroll, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.paperScroll, (Double)0.0);
        Rectangle ph = new Rectangle(root.getWidth(), root.getHeight(), (Paint)Color.TRANSPARENT);
        ph.widthProperty().bind((ObservableValue)root.widthProperty());
        ph.heightProperty().bind((ObservableValue)root.heightProperty());
        ap.getChildren().addAll((Object[])new Node[]{ph});
        this.paginationGroup.getChildren().add((Object)pagination);
        pagination.setOnMousePressed((EventHandler)new MouseClickLocationEventHandler());
        this.labelShapes = new Group();
        this.labelShapes.setManaged(false);
        this.labelShapes.getChildren().addAll((Object[])new Node[]{backLabel, nextLabel});
        PerspectiveTransform transform = this.createPerspectiveTransform();
        pagination.setEffect((Effect)transform);
        root.getChildren().addAll((Object[])new Node[]{ap, this.paginationGroup, this.labelShapes});
    }

    private Polygon createPolygonShape(String polygonName) {
        List startupPolygons = this.polygonLoader.getPolygon("/polygonDefinition.xml", "history");
        Polygon untransformed = this.polygonLoader.toJavaFXPolygon(this.polygonLoader.find(startupPolygons, polygonName));
        untransformed.setFill((Paint)Color.TRANSPARENT);
        return untransformed;
    }

    private Text getHistoryText() {
        String resourceName = this.resources.getMessage("history.hanseatic_league", new Object[0], this.locale.getCurrentLocal());
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        try {
            InputStream is = url.openStream();
            return this.textParser.parse(is);
        }
        catch (IOException e) {
            log.warn("History text could not be found: " + url.toExternalForm());
            return new Text();
        }
    }

    public void heightChange(double oldHeight, double newHeigth) {
        double top = Math.max(newHeigth - this.untransformedHeight - this.paginationGroup.getLayoutY() - 7.0, 0.0);
        this.paginationGroup.translateYProperty().set(top);
        double translateY = newHeigth - 766.0;
        this.labelShapes.translateYProperty().set(translateY);
    }

    public void widthChange(double oldWidth, double newWidth) {
        double left = Math.max(newWidth - this.untransformedWidth - this.paginationGroup.getLayoutX() - 36.0, 0.0);
        this.paginationGroup.translateXProperty().set(left);
        double translateX = newWidth - 1074.0;
        this.labelShapes.translateXProperty().set(translateX);
    }

    private class BackToStartupScene
    implements EventHandler<MouseEvent> {
        private BackToStartupScene() {
        }

        public void handle(MouseEvent arg0) {
            try {
                HanseaticHistoryScene.this.changeScene(HanseaticHistoryScene.this.uiFactory.getStartupScene());
            }
            catch (RuntimeException e) {
                log.error("Failed to switch back to startup scene", (Throwable)e);
            }
        }
    }
}

