package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
class RepairTask extends TimedTask {
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    private final IShip ship;

    public RepairTask(DateTime executionTime, IShip ship) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
    }

    @Override
    public void run() {
        ship.repair();
        ship.setAvailable(true);

        DisplayMessage msg = new DisplayMessage(messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message1", new Object[]{ship.getName()}, locale.getCurrentLocal()),
                messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message2", new Object[]{}, locale.getCurrentLocal()));
        clientServerEventBus.post(msg);
    }
}
