package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Mar 01, 2014
 */
@Service
public class ServerSideTaskFactory {
    @Autowired
    private ApplicationContext context;
    /**
     * Retrieve the ship repair task.
     * @return
     */
    public TimedTask getRepairTask(DateTime executionTime, IShip ship) {
        Object[] args = new Object[]{executionTime, ship};
        return (RepairTask)  context.getBean("repairTask", args);
    }

    /**
     * Retrieve the ship build task.
     * @return
     */
    public IShipBuildTask getShipBuildTask(DateTime executionTime, EShipType type, IPlayer owner, ShipFactory utility, double westPosition) {
        Object[] args = new Object[]{executionTime, type, owner, utility, westPosition};
        return (ShipBuildTask)  context.getBean("shipBuildTask", args);
    }
    /**
     * Retrieve the ship refit task.
     * @return
     */
    public TimedTask getRefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade) {
        Object[] args = new Object[]{executionTime, ship, upgrade};
        return (RefitShipTask)  context.getBean("refitShipTask", args);
    }
}
