/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class ShipBuildTask
extends TimedTask
implements IShipBuildTask {
    private final EShipType type;
    private final IPlayer owner;
    @Autowired
    private ShipFactory shipUtility;
    private final double x;
    private IShip ship;
    private static RandomNameLoader shipLoader = new RandomNameLoader("shipnames.properties");
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public ShipBuildTask(DateTime executionTime, EShipType type, IPlayer owner, double westPosition) {
        this.setExecutionTime(executionTime);
        this.owner = owner;
        this.type = type;
        this.x = westPosition;
    }

    @PostConstruct
    void initializeShip() {
        this.ship = this.createShip();
    }

    public void run() {
        DisplayMessage msg = new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask.message1", new Object[]{this.type, this.ship.getName()}, this.locale.getCurrentLocal()), this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.ShipBuildTask.message2", new Object[0], this.locale.getCurrentLocal()));
        this.clientServerEventBus.post((Object)msg);
    }

    public IShip getShipToBeBuilt() {
        return this.ship;
    }

    private IShip createShip() {
        ISnaikka ship = null;
        switch (this.type) {
            case SNAIKKA: {
                ship = this.shipUtility.createSnaikka(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case CRAYER: {
                ship = this.shipUtility.createCrayer(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case COG: {
                ship = this.shipUtility.createCog(shipLoader.getRandomName(), this.calculateShipCapacity());
                break;
            }
            case HOLK: {
                ship = this.shipUtility.createHolk(shipLoader.getRandomName(), this.calculateShipCapacity());
            }
        }
        ship.setOwner(this.owner);
        return ship;
    }

    private int calculateShipCapacity() {
        return this.shipUtility.calculateInitialCapacity(this.type, (double)((int)this.x));
    }
}

