/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTick;
import ch.sahits.game.event.data.ClockTickIntervalChange;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.city.AutomaticTradingEngine;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.engine.land.city.ShipyardEngine;
import ch.sahits.game.openpatrician.engine.land.city.TavernEngine;
import ch.sahits.game.openpatrician.javafx.util.IJavaFXApplicationThreadExecution;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CitiesState;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CityEngine
extends AbstractEngine {
    @Autowired
    private Random rnd;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ShipyardEngine shipyardEngine;
    private static final int WARE_UPDATES_MINUTES = 720;
    private int numberOfTicks;
    private int tickCounter = 0;
    private static final byte STOPPED = 0;
    private static final byte STARTED = 1;
    private byte state = 0;
    @Autowired
    private Date date;
    @Autowired
    private CitiesState citiesState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="serverEventBus")
    private AsyncEventBus serverEventBus;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    @Qualifier(value="javaFXApplicationThreadExecution")
    private IJavaFXApplicationThreadExecution threadExecutor;
    private Map<ICity, TavernEngine> tavernEngines = Maps.newHashMap();
    @Autowired
    private AutomaticTradingEngine automaticTradingEngine;
    @Autowired
    private LoanerEngine loanerEngine;

    @PostConstruct
    public void initialize() {
        this.numberOfTicks = 720 / this.date.getTickUpdate();
        this.clientServerEventBus.register((Object)this);
    }

    @Subscribe
    public void handleClockTickIntervallChange(ClockTickIntervalChange event) {
        this.numberOfTicks = event.getInterval() == 0 ? -1 : 720 / event.getInterval();
    }

    int getNumberOfTicks() {
        return this.numberOfTicks;
    }

    @Subscribe
    public void handleClockTicked(ClockTick event) {
        ++this.tickCounter;
        if (this.tickCounter == this.numberOfTicks && this.state == 1) {
            this.tickCounter = 0;
            this.threadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CityEngine.this.produceAndConsumeWares();
                }
            });
        }
    }

    private void produceAndConsumeWares() {
        for (CityState state : this.citiesState.getCityEngineStates()) {
            state.consumeWares();
            state.produceWares();
        }
    }

    private void addCity(ICity city) {
        CityState cityState = this.gameFactory.getCityState(city);
        TavernEngine tavernEngine = (TavernEngine)this.context.getBean("tavernEngine", new Object[]{cityState.getTavernState(), city});
        this.tavernEngines.put(city, tavernEngine);
        this.loanerEngine.addNewLoaner(city);
    }

    public void start(IGame game) {
        for (ICity city : game.getMap().getCities()) {
            this.addCity(city);
        }
        this.state = 1;
    }

    @Override
    public List<AbstractEngine> getChildren() {
        ArrayList engines = Lists.newArrayList();
        for (TavernEngine tavernEngine : this.tavernEngines.values()) {
            engines.add(tavernEngine);
        }
        engines.add(this.shipyardEngine);
        engines.add(this.automaticTradingEngine);
        engines.add(this.loanerEngine);
        return engines;
    }

    public ShipyardEngine getShipyardEngine() {
        return this.shipyardEngine;
    }
}

