/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.land.CaptainEngine;
import ch.sahits.game.openpatrician.model.IUpdatableCityRelatedState;
import ch.sahits.game.openpatrician.model.IUpdateableState;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class TavernEngine
extends AbstractEngine {
    @Autowired
    private Random rnd;
    private final TavernState state;
    @Value(value="${beggar.salior.ratio}")
    private int beggarSailorRation;
    @Autowired
    private CaptainEngine captainEngine;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final ICity city;

    public TavernEngine(TavernState state, ICity city) {
        this.state = state;
        this.city = city;
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList((Object[])new AbstractEngine[]{this.captainEngine});
    }

    @PostConstruct
    private void init() {
        int nbSailors = this.computeNumbersOfSailors();
        this.state.getSailors().setNumberOfSailors(nbSailors);
        this.handlePersonsBecomingAbsent();
        this.handlePersonsBecomingPresent();
        this.clientServerEventBus.register((Object)this);
    }

    private int computeNumbersOfSailors() {
        int nbBeggars = this.city.getPopulation(EPopulationClass.BEGGAR);
        int nbSailors = (int)((double)(nbBeggars / this.beggarSailorRation) * this.rnd.nextDouble() * 2.0);
        return nbSailors;
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        int nbSailors = this.computeNumbersOfSailors();
        this.state.getSailors().setNumberOfSailors(nbSailors);
        this.handlePersonsBecomingAbsent();
        this.handlePersonsBecomingPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingAbsent() {
        ObservableList present = this.state.presentPersonsProperty();
        ArrayList leavingPersons = Lists.newArrayList();
        for (IPerson p : present) {
            if (!(p instanceof ITavernPerson)) continue;
            ITavernPerson person = (ITavernPerson)p;
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double presenceTime = Math.abs(person.getNumberOfDaysSinceArrival());
            double absence = this.rnd.nextDouble() * 2.0 * maxPresence / presenceTime;
            if (!(absence > 0.5)) continue;
            leavingPersons.add(person);
        }
        TavernState tavernState = this.state;
        synchronized (tavernState) {
            for (ITavernPerson person : leavingPersons) {
                person.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePersonsBecomingPresent() {
        ObservableList absent = this.state.absentPersonProperty();
        ArrayList arrivingPersons = Lists.newArrayList();
        for (ITavernPerson person : absent) {
            double maxPresence = Math.abs(person.getMaxDaysPresent());
            double maxNbAbsence = Math.abs(person.getMaxDaysAbsent());
            double absentTime = (double)person.getNumberOfDaysSinceArrival() - maxPresence;
            double presence = this.rnd.nextDouble() * 2.0 * (absentTime / maxNbAbsence);
            if (!(presence > 0.5)) continue;
            if (person instanceof IUpdateableState) {
                ((IUpdateableState)person).update();
            } else if (person instanceof IUpdatableCityRelatedState) {
                ((IUpdatableCityRelatedState)person).update(this.city);
            } else {
                throw new IllegalArgumentException("Person is not updatable: " + person);
            }
            arrivingPersons.add(person);
        }
        TavernState tavernState = this.state;
        synchronized (tavernState) {
            for (ITavernPerson person : arrivingPersons) {
                person.arrive();
            }
        }
    }

    public void hireSailor() {
        this.state.getSailors().hire();
        int nbBeggars = this.city.getPopulation(EPopulationClass.BEGGAR);
        this.city.setPopulation(--nbBeggars, EPopulationClass.BEGGAR);
    }

    public void fireSailor() {
        this.state.getSailors().fire();
        int nbBeggars = this.city.getPopulation(EPopulationClass.BEGGAR);
        this.city.setPopulation(++nbBeggars, EPopulationClass.BEGGAR);
    }
}

