package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.event.data.IClockTick;
import ch.sahits.game.openpatrician.model.Date;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.TimerTask;

/**
 * Timer task updating the date by one tick
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 27, 2011
 *
 */
@Component
public class ClockTick extends TimerTask {
    @Autowired
    private Date clock;
    @Autowired
    @Qualifier("serverEventBus")
    private AsyncEventBus serverEventBus;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    /** Lock for guaranteeing thread safety */
    private static Object lock = new Object();

    @Override
    public void run() {
        tick();
        serverEventBus.post(new IClockTick(){});
    }

    /**
     * Update the time by one tick.
     */
    public void tick(){
        synchronized (lock) {
            int dayBefore = clock.getCurrentDate().getDayOfMonth();
            clock.updateTime(clock.getCurrentDate().plusMinutes(clock.getTickUpdate()));
            if (dayBefore!=clock.getCurrentDate().getDayOfMonth()){
                clock.dayDateBinding().invalidate();
                final ClockTickDayChange event = new ClockTickDayChange();
//                serverEventBus.post(event);
                clientServerEventBus.post(event);
            }
        }
        clientServerEventBus.post(new ch.sahits.game.event.data.ClockTick());
    }

}
