package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import org.springframework.stereotype.Service;

/**
 * This abstraction layer for creating engines allows better decoupling and allows therefore easier testing.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 20, 2014
 */
@Service
public class EngineFactory {

    public AIPlayerEngine createAIPlayerEngine(IAIPlayer player) {
        return new AIPlayerEngine(player);
    }
}
