package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.impl.Ship;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
class RefitShipTask extends TimedTask {

    private final IShip ship;
    private final EShipUpgrade level;
    @Autowired
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public RefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
        level = upgrade;
    }

    @Override
    public void run() {
        while (ship.getShipUpgradeLevel() != level) {
            ship.upgrade();
            ((Ship)ship).setShipWeaponsLocation(shipWeaponLocationFactory.getShipWeaponsLocation(ship.getShipType(), level));
        }
        ship.setAvailable(true);
        int currentCapacity = ship.getCapacity();

        DisplayMessage msg = new DisplayMessage(messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message1", new Object[]{ship.getShipType(), level, currentCapacity}, locale.getCurrentLocal()),
                messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message2", new Object[]{}, locale.getCurrentLocal()));
        clientServerEventBus.post(msg);

    }
}
