package ch.sahits.game.openpatrician.javafx.util;

import javafx.application.Platform;
import org.springframework.stereotype.Service;

/**
 * Implementation delegating to the JavaFX thread through Platform.runLater
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 08, 2014
 */
@Service
public class JavaFXApplicationThreadExecution implements IJavaFXApplicationThreadExecution {
    @Override
    public void execute(Runnable executable) {
        Platform.runLater(executable);
    }
}
