/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.impl.Ship;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class RefitShipTask
extends TimedTask {
    private final IShip ship;
    private final EShipUpgrade level;
    @Autowired
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public RefitShipTask(DateTime executionTime, IShip ship, EShipUpgrade upgrade) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
        this.level = upgrade;
    }

    public void run() {
        while (this.ship.getShipUpgradeLevel() != this.level) {
            this.ship.upgrade();
            ((Ship)this.ship).setShipWeaponsLocation(this.shipWeaponLocationFactory.getShipWeaponsLocation(this.ship.getShipType(), this.level));
        }
        this.ship.setAvailable(true);
        int currentCapacity = this.ship.getCapacity();
        DisplayMessage msg = new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message1", new Object[]{this.ship.getShipType(), this.level, currentCapacity}, this.locale.getCurrentLocal()), this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RefitShipTask.message2", new Object[0], this.locale.getCurrentLocal()));
        this.clientServerEventBus.post((Object)msg);
    }
}

