/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class RepairTask
extends TimedTask {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final IShip ship;

    public RepairTask(DateTime executionTime, IShip ship) {
        this.setExecutionTime(executionTime);
        this.ship = ship;
    }

    public void run() {
        this.ship.repair();
        this.ship.setAvailable(true);
        DisplayMessage msg = new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message1", new Object[]{this.ship.getName()}, this.locale.getCurrentLocal()), this.messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message2", new Object[0], this.locale.getCurrentLocal()));
        this.clientServerEventBus.post((Object)msg);
    }
}

