/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ShipyardOrderBuild;
import ch.sahits.game.event.data.ShipyardOrderRefit;
import ch.sahits.game.event.data.ShipyardOrderRepair;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.impl.IShipBuildTask;
import ch.sahits.game.openpatrician.model.city.impl.ShipDueDate;
import ch.sahits.game.openpatrician.model.city.impl.ShipyardState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ShipyardEngine
extends AbstractEngine {
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private ShipFactory shipUtility;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    private DateTime orderShipBuilding(IShipyard shipyard, EShipType type, IPlayer owner) {
        ((ShipyardState)shipyard).cleanup();
        int buildTime = shipyard.calculateBuildTime(type);
        DateTime startDate = this.date.getCurrentDate();
        for (IShipDueDate dueDate : shipyard.getShipBuildingList()) {
            if (!dueDate.getDueDate().isAfter((ReadableInstant)startDate)) continue;
            startDate = dueDate.getDueDate();
        }
        DateTime finished = startDate.plusDays(buildTime);
        TimedTask task = (TimedTask)this.taskFactory.getShipBuildTask(finished, type, owner, this.shipUtility, shipyard.getCity().getCoordinates().getX());
        ShipDueDate dueDate = new ShipDueDate(((IShipBuildTask)task).getShipToBeBuilt(), finished);
        shipyard.addShipBuildingOrder((IShipDueDate)dueDate, Optional.of((Object)task));
        this.taskList.add(task);
        return finished;
    }

    private void repair(IShipyard shipyard, IShip ship) {
        ((ShipyardState)shipyard).cleanup();
        int repairTime = shipyard.calculateBuildTime(ship.getShipType());
        int damageInv = ship.getDamage();
        int damage = (int)Math.rint((double)(100 - damageInv) / 100.0);
        ShipDueDate dueDate = new ShipDueDate(ship, this.date.getCurrentDate().plusDays(repairTime *= damage));
        TimedTask task = this.taskFactory.getRepairTask(dueDate.getDueDate(), ship);
        this.taskList.add(task);
        ship.setAvailable(false);
        shipyard.addShipRepairOrder((IShipDueDate)dueDate, Optional.of((Object)task));
    }

    private void refit(IShipyard shipyard, IShip ship, EShipUpgrade upgradeLevel) {
        ((ShipyardState)shipyard).cleanup();
        int refitTime = shipyard.calculateRefitTime(ship.getShipType());
        EShipUpgrade level = ship.getShipUpgradeLevel();
        int indexStartLevel = 0;
        int indexFinalLevel = 0;
        for (int i = 0; i < EShipUpgrade.values().length; ++i) {
            if (EShipUpgrade.values()[i] == level) {
                indexStartLevel = i;
            }
            if (EShipUpgrade.values()[i] != upgradeLevel) continue;
            indexFinalLevel = i;
            break;
        }
        int nbLevelUpgrades = Math.max(indexFinalLevel - indexStartLevel, 0);
        ShipDueDate dueDate = new ShipDueDate(ship, this.date.getCurrentDate().plusDays(refitTime * nbLevelUpgrades));
        TimedTask task = this.taskFactory.getRefitShipTask(dueDate.getDueDate(), ship, upgradeLevel);
        this.taskList.add(task);
        ship.setAvailable(false);
        shipyard.addShipRefitOrder((IShipDueDate)dueDate, Optional.of((Object)task));
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }

    @Subscribe
    public void handleOrderBuildEvent(ShipyardOrderBuild event) {
        this.orderShipBuilding(event.getShipyard(), event.getShipType(), event.getOwner());
    }

    @Subscribe
    public void handleOrderRepair(ShipyardOrderRepair event) {
        this.repair(event.getShipyard(), event.getShip());
    }

    @Subscribe
    public void handleORderRefit(ShipyardOrderRefit event) {
        this.refit(event.getShipyard(), event.getShip(), event.getUpgradeLevel());
    }
}

