/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.spring;

import ch.sahits.game.openpatrician.engine.land.city.TavernEngine;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Configuration
@ComponentScan(value={"ch.sahits.game.openpatrician.engine", "ch.sahits.game.openpatrician.javafx.util"})
public class EngineConfiguration {
    @Bean
    public static PropertyPlaceholderConfigurer applicationServerProperties() {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("model-settings.properties")});
        return bean;
    }

    @Bean
    @Scope(value="prototype")
    public TavernEngine tavernEngine(TavernState tavernState, ICity city) {
        return new TavernEngine(tavernState, city);
    }
}

