package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
class RepairTask extends TimedTask {
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;

    private final IShip ship;
    protected final ICityPlayerProxyJFX city;

    public RepairTask(DateTime executionTime, IShip ship, ICityPlayerProxyJFX city) {
        super();
        setExecutionTime(executionTime);
        this.ship = ship;
        this.city = city;
    }

    @Override
    public void run() {
        ship.repair();
        ship.setAvailable(true);
        city.getPlayersShips().add(ship);
        if (city.getPlayersShips().size() == 1) {
            city.activateShip(ship);
        }
        DisplayMessage msg = new DisplayMessage(messageSource.getMessage("ch.sahits.game.openpatrician.engine.event.task.RepairTask.message", new Object[]{ship.getName()}, locale.getCurrentLocal()));
        clientEventBus.post(msg);
    }
}
