package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.model.city.cityhall.IEldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.EldermanOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import java.util.Optional;
import org.joda.time.DateTime;



/**
 * Task for filing a city violation.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 07, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AddViolationTask extends TimedTask{
    private final ICityViolation violation;
    private final IEldermanOffice office;

    public AddViolationTask(ICityViolation violation, IEldermanOffice office, DateTime electionTime) {
        this.violation = violation;
        this.office = office;
        setExecutionTime(electionTime);
    }

    @Override
    public void run() {
        if (!office.getViolation().isPresent()) {
            ((EldermanOffice)office).setViolation(Optional.of(violation));
        }
    }
}
