package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Ballot;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import org.joda.time.DateTime;

/**
 * Voting task that is timed.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 02, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class VoteTask extends TimedTask {
    private final Ballot result;
    private final boolean voteYes;
    public VoteTask(Ballot result, DateTime electionTime, boolean yes) {
        this.result = result;
        voteYes = yes;
        setExecutionTime(electionTime);
    }

    @Override
    public void run() {
        result.vote(voteYes);
    }
}
